<?php
/**
 * Include CSS files required by the Tabulizer editor plugin 
 *     
 * @package		tabulizer
 * @copyright	Copyright © 2011 - All rights reserved.
 * @license		GNU/GPL
 * @author		Dimitrios Mourloukos
 * @author mail	info@alterora.gr
 * @website		www.alterora.gr
 *
 */ 

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.plugin.plugin' );

class  plgSystemTabulizerCSS extends JPlugin
{
	function plgSystemTabulizerCSS(&$subject, $config) {
		parent::__construct($subject, $config);			
		$this->loadLanguage();		
	}
	
	function onAfterRender()  {	
		$JApplication=JFactory::getApplication();
		
		// don't run this plugin on administrator site		
		if ($JApplication->isAdmin()) {
			return;			
		}			
			
		$output = JResponse::getBody();		 
		$this->_includeCSS($output);				
		JResponse::setBody($output);				
	}	
	
	protected function _includeCSS(&$text) {							
		# get the tabulizer defines (requires tabulizer editor plugin to be installed properly
		if(version_compare(JVERSION,'1.6.0','ge')) {
			// Joomla! 1.6 code here
			$defines_dir = JPATH_PLUGINS. DS .'editors-xtd'. DS. 'tabulizer' . DS . 'tabulizer'. DS . 'defines.php';
		} else {
			// Joomla! 1.5 code here
			$defines_dir = JPATH_PLUGINS. DS .'editors-xtd'. DS. 'tabulizer' . DS . 'defines.php';
		}						
		
		if (file_exists($defines_dir)) {
			require_once($defines_dir);
		} else {
			$msg = JText::_('TABULIZER PLUGIN MISSING OR NOT INSTALLED PROPERLY');
			JError::raiseWarning( 101, $msg );	
			return false;
		}
	
		$cssfiles = array();
		$css_dir = JPATH_SITE.DS.RULES_CSS_DIR;
				
		$pattern = TABULIZER_INCLUDE_STYLE_REGEX;
		$replacement = '';								
		
		# find occurances of tabulizer include css directive
		while (preg_match($pattern, $text, $regs, PREG_OFFSET_CAPTURE)) {						
			$replacement = '';		
			$file = $regs[1][0];
			if (preg_match('/^[a-zA-Z0-9\._\-]{2,128}\.css$/i',$file)) {								
				if (!isset($cssfiles[$file])) {					
					$replacement = '<link rel="stylesheet" href="'.RULES_CSS_DIR . $file.'" type="text/css" />';
					$cssfiles[$file] = $file;
				}	
			}
			// Replace the found tabulizer directive
			$text = substr_replace($text, $replacement, $regs[0][1], strlen($regs[0][0]));			
		}				
				
	}
	

}

?>