<?php
/**
 * Include CSS files required by the Tabulizer editor plugin 
 *     
 * @package		tabulizer
 * @copyright	Copyright © 2011 - All rights reserved.
 * @license		GNU/GPL
 * @author		Dimitrios Mourloukos
 * @author mail	info@alterora.gr
 * @website		www.alterora.gr
 *
 */ 

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.plugin.plugin' );

class  plgContentTabulizerCSS extends JPlugin
{
	function plgContentTabulizerCSS(&$subject, $config) {
		parent::__construct($subject, $config);			
		$this->loadLanguage();		
	}
	
	public function onContentPrepare($context, &$row, &$params, $page = 0)
	{
		$JApplication=JFactory::getApplication();
		
		// don't run this plugin on administrator site		
		if ($JApplication->isAdmin()) {
			return true;			
		}	
		
		// Don't run this plugin when the content is being indexed
		if (!empty($context)) {
			if ($context == 'com_finder.indexer') {
				return true;
			}
		}

		if (is_object($row)) {
			return $this->_includeCSS($row->text);
		}
		return $this->_includeCSS($row);										
	}
	
	public function onPrepareContent( &$article, &$params, $limitstart = 0 )
	{
		$JApplication=JFactory::getApplication();
		
		// don't run this plugin on administrator site		
		if ($JApplication->isAdmin()) {
			return true;			
		}			

		return $this->_includeCSS($article->text);
	}	
	
	protected function _includeCSS(&$text) {							
		# get the tabulizer defines (requires tabulizer editor plugin to be installed properly
		if(version_compare(JVERSION,'1.6.0','ge')) {
			// Joomla! 1.6 code here
			$defines_dir = JPATH_PLUGINS. DS .'editors-xtd'. DS. 'tabulizer' . DS . 'tabulizer'. DS . 'defines.php';
		} else {
			// Joomla! 1.5 code here
			$defines_dir = JPATH_PLUGINS. DS .'editors-xtd'. DS. 'tabulizer' . DS . 'defines.php';
		}
		
		if (file_exists($defines_dir)) {
			require_once($defines_dir);
		} else {
			$msg = JText::_('TABULIZER PLUGIN MISSING OR NOT INSTALLED PROPERLY');
			JError::raiseWarning( 101, $msg );	
			return false;
		}
	
		$cssfiles = array();
		$css_dir = JPATH_SITE.DS.RULES_CSS_DIR;
				
		$pattern = TABULIZER_INCLUDE_STYLE_REGEX;
		$replacement = '';								
		
		# find occurances of tabulizer include css directive
		while (preg_match($pattern, $text, $regs, PREG_OFFSET_CAPTURE)) {						
			$file = $regs[1][0];
			if (preg_match('/^[a-zA-Z0-9\._\-]{2,128}\.css$/i',$file)) {				
				if (!isset($cssfiles[$file])) {
					$cssfiles[$file] = $file;
				}
			}
			// Replace the found tabulizer directive
			$text = substr_replace($text, $replacement, $regs[0][1], strlen($regs[0][0]));			
		}
		
		if (!empty($cssfiles)) {						
			$doc=JFactory::getDocument();
			foreach ($cssfiles as $file) {
				if (is_file($css_dir . $file)) {					
					$css_file = RULES_CSS_DIR . $file;					
					$doc->addStyleSheet($css_file);
				}
			}
		}				

	}
	

}

?>