<?php
/**
 * @version		2.0.0 tabulizer $
 * @package		tabulizer
 * @copyright	Copyright © 2011 - All rights reserved.
 * @license		GNU/GPL
 * @author		Dimitrios Mourloukos
 * @author mail	info@alterora.gr
 * @website		www.alterora.gr
 * 
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

if(version_compare(JVERSION,'1.6.0','ge')) {
	// Joomla! 2.5 code
	define('TABULIZER_INCLUDE_PATH', JPATH_PLUGINS . DS .'editors-xtd' . DS . 'tabulizer' . DS . 'tabulizer' . DS );
} else {
	define('TABULIZER_INCLUDE_PATH', JPATH_PLUGINS . DS .'editors-xtd' . DS . 'tabulizer' . DS );
}	

// load administrator's language files
$lang =& JFactory::getLanguage();
$lang->load('com_tabulizer', JPATH_ADMINISTRATOR);

// make sure the plugin is installed
$defines_dir = TABULIZER_INCLUDE_PATH . 'defines.php';
if (file_exists($defines_dir)) {
	require_once($defines_dir);
} else {
	$msg = JText::_('TABULIZER PLUGIN MISSING OR NOT INSTALLED PROPERLY');
	JError::raiseWarning( 101, $msg );	
}

// Require once css files
JHTML::_('stylesheet', 'tabulizer.css', 'administrator/components/com_tabulizer/assets/css/');

// Require the base controller
require_once (JPATH_COMPONENT_ADMINISTRATOR.DS.'controller.php');

// Create the controller
$controller = new tabulizerController();

// Perform the Request task
$controller->execute(JRequest::getVar('task', null, 'default', 'cmd'));
$controller->redirect();
?>