<?php

// no direct access
defined('_JEXEC') or die('Restricted access');

$option = JRequest::getCmd('option');

require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'assets'.DS.'classes'.DS.'message.php');

$archive_filename = $this->archive_filename;
$archive_name = $this->archive_name;
$archive_title = $this->archive_title;
$archive_style = empty($this->archive_style)?'':$this->archive_style;
$title = JText::_('COM_TABULIZER_RULESET_ARCHIVE' );
if (!empty($archive_title)) $title .= ': ' . $archive_title;
else if (!empty($archive_name)) $title .= ': ' . $archive_name;
else $title .= ' ('.$archive_filename.XML_FILE_EXT.')'; 

$return_url = str_replace('&amp;','&',JRoute::_('index.php?option='.$option.'&task=viewrulesetarchives'));

JHTML::_('behavior.tooltip');
JToolBarHelper::title($title);
JToolBarHelper::back(JText::_('COM_TABULIZER_BACK_TO_ARCHIVES'), $return_url);
JToolBarHelper::help( 'all_topics', true );

$class_path = TABULIZER_INCLUDE_PATH . 'assets' . DS . 'class.php';
$rules_path = JPATH_SITE . DS. RULES_XML_DIR;
$css_path = JPATH_SITE . DS. RULES_CSS_DIR;

if (!file_exists($class_path)) {
	TabulizerUserMessage::printError(JText::_('COM_TABULIZER_PLUGIN_NOT_INSTALLED'));	
} else if (empty($this->rulesets)) {		
	$msg = sprintf(JText::_('COM_TABULIZER_NO_RULESET_WERE_FOUND'), JText::_('COM_TABULIZER_NEW_RULESET'));
	TabulizerUserMessage::printInfo($msg);	
} else {	
	require_once($class_path);
	$table = new Tabulizer();
	$table->setDir($rules_path);
	
	// load applicable css styles 
	$style_sep = empty($archive_style)?'':';';
	$rows = &$this->rulesets;	
	foreach ($rows as $row) {
		if (!empty($row['style'])) {
			$archive_style .= $style_sep . $row['style'];
			$style_sep = ';';
		}
	}	
	
	if (!empty($archive_style)) {
		$archive_css_files = explode(';',$archive_style);		
		$cssfiles = array();
		$dir = $css_path;
		$url_dir = JURI::root() . RULES_CSS_DIR;				
		if (is_dir($dir)) {
			if ($dh = opendir($dir)) {					
				while (($file = readdir($dh)) !== false) {				
					if (is_file($dir . $file)) {
						if (in_array($file,$archive_css_files)) {
							$cssfiles[] = $url_dir . $file;
						}					
					}
				}	
				closedir($dh);
			} 			
		}
		if (!empty($cssfiles)) {
			$doc=JFactory::getDocument();
			foreach ($cssfiles as $cssfile) {					
				$doc->addStyleSheet($cssfile);
			}
		}		
	}

	echo '<strong><em>'.JText::_('COM_TABULIZER_SAMPLE_TABLES').'</em></strong>' . "<br>\n";
	
	$rows = &$this->rulesets;	
	foreach ($rows as $row) {
		$name = $row['name'];
		$title = $row['title'];
		$description = $row['description'];		
		$html = '';
		$errors = array();
		
		if (!empty($description)) {
			$tooltip = JHTML::tooltip($description, $title);
			$title = $title . ' ' . $tooltip;
		}
		
		if (!empty($row['sample_data'])) {
			$ruleset_sample_data_text = $row['sample_data_text'];
			$ruleset_sample_data_sep = empty($row['sample_data_sep'])?'cm':$row['sample_data_sep'];
			$ruleset_sample_data_enc = 	empty($row['sample_data_enc'])?'none':$row['sample_data_enc'];			
		} else {
			$ruleset_sample_data_text = null;
			$ruleset_sample_data_sep = null;
		}
		
		echo "<hr><h3>{$title}</h3>\n";		
		
		if ($table->previewRuleset($name, $html, $errors, $ruleset_sample_data_text, $ruleset_sample_data_sep, $ruleset_sample_data_enc)) {
			echo $html;			
		} else {
			$msg = JText::_('COM_TABULIZER_ERRORS_FOUND'). '<br/><ul>';
			foreach ($errors as $error) {
				$msg .= '<li>'.$error.'</li>';
			}
			$msg .= '</ul>';
			TabulizerUserMessage::printError($msg);
		}
						
	}
}	
?>
