<?php
defined('_JEXEC') or die('Restricted access');

$option = JRequest::getCmd('option');

$return_url = str_replace('&amp;','&',JRoute::_('index.php?option='.$option.'&task=viewrulesetarchives'));
$used_archive_filename = $this->lists['used_archive_filenames'];
$used_archive_name = $this->lists['used_archive_names'];

JHTML::_('behavior.tooltip');
$edit = $this->lists['edit'];
$text = !$edit ? JText::_('COM_TABULIZER_NEW' ) : JText::_('COM_TABULIZER_EDIT' );
JToolBarHelper::title(   JText::_('COM_TABULIZER_RULESET_ARCHIVE' ).': <small><small>[ ' . $text.' ]</small></small>','config' );
JToolBarHelper::save();
if (!$edit)  {
	JToolBarHelper::cancel();
} else {
	// for existing items the button is renamed `close`
	JToolBarHelper::cancel( 'cancel', JText::_('COM_TABULIZER_CLOSE') );
}
JToolBarHelper::help( 'all_topics', true );

$cssfile = JURI::root() . 'administrator/components/com_tabulizer/assets/css/tabulizer.css';
$doc=JFactory::getDocument();
$doc->addStyleSheet($cssfile);

?>

<script language="javascript" type="text/javascript">		
	
	function isUsedFilename(filename) {
		var used_filenames = [<?php echo $used_archive_filename; ?>];				
		if (used_filenames.indexOf(filename) >=0) return true;
		else return false;
	}

	function isUsedName(name) {
		var used_names = [<?php echo $used_archive_name; ?>];
		if (used_names.indexOf(name) >=0) return true;
		else return false;
	}
	
	function validateAndSubmit() {
		var form = document.adminForm;	
		var value, regex, valid = true, error_msg = "";
				
		regex = /^.{2,128}$/;
		value = form.archive_title.value;
		if (!regex.test(value)) {
			error_msg = error_msg + "\n* <?php echo JText::_('COM_TABULIZER_INVALID_RULESET_ARCHIVE_TITLE');?>";
			valid = false;		
		}
		
		regex = /^[a-zA-Z0-9\._\-]{2,128}$/;
		value = form.archive_name.value;
		if (!regex.test(value)) {
			error_msg = error_msg + "\n* <?php echo JText::_('COM_TABULIZER_INVALID_RULESET_ARCHIVE_NAME');?>";
			valid = false;		
		} else if (isUsedName(value)) {
			error_msg = error_msg + "\n* <?php echo JText::_('COM_TABULIZER_RULESET_ARCHIVE_NAME_ALREADY_IN_USE');?>";
			valid = false;		
		}
		
		regex = /^[a-zA-Z0-9\._\-]{2,128}\<?php echo XML_FILE_EXT;?>$/i;
		value = form.archive_filename.value;
		if (!regex.test(value)) {
			error_msg = error_msg + "\n* <?php echo JText::_('COM_TABULIZER_INVALID_RULESET_ARCHIVE_FILENAME');?>";
			valid = false;		
		} else  if (isUsedFilename(value)) {
			error_msg = error_msg + "\n* <?php echo JText::_('COM_TABULIZER_RULESET_ARCHIVE_FILENAME_ALREADY_IN_USE');?>";
			valid = false;		
		}
		
		regex = /^([a-zA-Z0-9\._\-]{2,128}\.css)+(;[a-zA-Z0-9\._\-]{2,128}\.css)*$/i;
		value = form.archive_style.value;
		if (value != '') {
			if (!regex.test(value)) {
				error_msg = error_msg + "\n* <?php echo JText::_('COM_TABULIZER_INVALID_RULESET_ARCHIVE_STYLE');?>";
				valid = false;		
			}
		}
				
		if (valid) {
			form.submit();
		} else {
			error_msg = "<?php echo JText::_('COM_TABULIZER_JS_ERRORS_FOUND'); ?>" + error_msg;
			alert(error_msg);
		}	
						
	}
	
<?php if(version_compare(JVERSION,'1.6.0','ge')) { ?>		
	
	Joomla.submitbutton = function(pressbutton) {											
		if (pressbutton == 'save') {
			validateAndSubmit();
		} else if (pressbutton == 'cancel') {
			window.location = "<?php echo $return_url;?>";			
		}		
	}
	
<?php } else { ?>
	
	function submitbutton(pressbutton) {
		if (pressbutton == 'save') {
			validateAndSubmit();
		} else if (pressbutton == 'cancel') {
			window.location = "<?php echo $return_url;?>";			
		}											
	}	
	
<?php } ?>		
	
</script>


<form action="index.php" method="post" name="adminForm" id="adminForm">
<div class="col width-60">
	<fieldset class="adminform">
		<legend><?php echo JText::_('COM_TABULIZER_RULESET_ARCHIVE_DETAILS' ); ?></legend>

		<table class="admintable">
		<tr>
			<td  align="right" class="key">
				<?php echo JText::_('COM_TABULIZER_RULESET_ARCHIVE_FILENAME' ); ?>:
			</td>
			<td>
				<?php echo $this->lists['filename']; ?>
			</td>
		</tr>		
		<tr>
			<td  align="right" class="key">				
				<?php echo JText::_('COM_TABULIZER_RULESET_ARCHIVE_TITLE' ); ?>:
			</td>
			<td>
				<?php echo $this->lists['title']; ?>
			</td>
		</tr>
		<tr>
			<td  align="right" class="key">
				<?php echo JText::_('COM_TABULIZER_RULESET_ARCHIVE_NAME' ); ?>:
			</td>
			<td>
				<?php echo $this->lists['name']; ?>
			</td>
		</tr>
		<tr>
			<td  align="right" class="key">
				<?php echo JText::_('COM_TABULIZER_RULESET_ARCHIVE_STYLE' ); ?>:
			</td>
			<td>
				<?php echo $this->lists['style']; ?>
			</td>
		</tr>
	    </table>
	</fieldset>
</div>

<div class="clr"></div>
	<input type="hidden" name="option" value="com_tabulizer" />		
	<input type="hidden" name="task" value="saveRulesetArchive" />
	<?php echo JHTML::_( 'form.token' ); ?>
</form>

<?php
TabulizerUserMessage::printHelp(JText::_('COM_TABULIZER_FORM_RULESET_ARCHIVE_HELP'));
?>