<?php
// no direct access
defined('_JEXEC') or die('Restricted access');

$option = JRequest::getCmd('option');

$archive_filename = $this->archive_filename;
$archive_name = $this->archive_name;
$archive_title = $this->archive_title;
$title = JText::_('COM_TABULIZER_RULESET_ARCHIVE' );
if (!empty($archive_title)) $title .= ': ' . $archive_title;
else if (!empty($archive_name)) $title .= ': ' . $archive_name;
else $title .= ' ('.$archive_filename.XML_FILE_EXT.')'; 

$return_url = str_replace('&amp;','&',JRoute::_('index.php?option='.$option.'&task=viewrulesetarchives'));

JHTML::_('behavior.tooltip');
JToolBarHelper::title($title);
JToolBarHelper::back(JText::_('COM_TABULIZER_BACK_TO_ARCHIVES'), $return_url);
JToolBarHelper::addNew('newRuleset', JText::_('COM_TABULIZER_NEW_RULESET'));
if (!empty($this->rulesets)) {
	JToolBarHelper::deleteList(JText::_('COM_TABULIZER_DELETE_RULESET_CONFIRM'), 'deleteRuleset', JText::_('COM_TABULIZER_DELETE_RULESET'));
}
JToolBarHelper::help( 'all_topics', true );

if (empty($this->rulesets)) {		
	$msg = sprintf(JText::_('COM_TABULIZER_NO_RULESET_WERE_FOUND'), JText::_('COM_TABULIZER_NEW_RULESET'));
	TabulizerUserMessage::printInfo($msg);	
?>

<form action="index.php" method="post" name="adminForm">
<input type="hidden" name="option" value="<?php echo $option; ?>" />
<input type="hidden" name="task" value="" />
<input type="hidden" name="archive_filename" value="<?php echo htmlspecialchars($archive_filename,ENT_COMPAT,'UTF-8');?>" />
<input type="hidden" name="boxchecked" value="0"/>
<?php echo JHTML::_( 'form.token' ); ?>
</form>	
<?php	
} else {
	$rows = &$this->rulesets;
?>

<form action="index.php" method="post" name="adminForm">
<table class="adminlist">
	<thead>
		<tr>
			<th width="20"><input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count($rows); ?>)" /></th>
			<th class="title"><?php echo JText::_('COM_TABULIZER_RULESET_TITLE');?></th>
			<th><?php echo JText::_('COM_TABULIZER_RULESET_NAME');?></th>
			<th><?php echo JText::_('COM_TABULIZER_RULESET_SUFFIX');?></th>
			<th><?php echo JText::_('COM_TABULIZER_RULESET_STYLE');?></th>
			<th><?php echo JText::_('COM_TABULIZER_PRESELECTED');?></th>			
			<th width="220"><?php echo JText::_('COM_TABULIZER_ACTIONS');?></th>
		</tr>
	</thead>
	<?php				
	jimport('joomla.filter.output');
	$k=0;
	$i=0;
	foreach ($rows as $row) {					
		if ($row['preselected']) $ruleset_preselected = '<img src="components/com_tabulizer/assets/images/yes.png" style="padding-right: 5px">'. JText::_('COM_TABULIZER_YES'); else $ruleset_preselected = '';
		$ruleset_name = urlencode($row['name']);	
		$ruleset_name_url = urlencode($ruleset_name);	
		$archive_filename_url = urlencode($archive_filename);
		
		$id = $ruleset_name_url;
		$k=1-$k;					
		$checked = JHTML::_('grid.id', $i, $id);				
											
		$view_link = JFilterOutput::ampReplace ('index.php?option='.$option.'&task=viewRuleset&ruleset_name='.$ruleset_name_url.'&archive_filename='.$archive_filename_url.'&cid[]='.$id);
		$preview_link = JFilterOutput::ampReplace ('index.php?option='.$option.'&task=viewRulesetPreview&ruleset_name='.$ruleset_name_url.'&archive_filename='.$archive_filename_url.'&cid[]='.$id);		
		$edit_link = JFilterOutput::ampReplace ('index.php?option='.$option.'&task=editRuleset&ruleset_name='.$ruleset_name_url.'&archive_filename='.$archive_filename_url.'&cid[]='.$id);
		$delete_link = JFilterOutput::ampReplace ('index.php?option='.$option.'&task=deleteRuleset&archive_filename='.$archive_filename_url.'&cid[]='.$id.'&'. JUtility::getToken() .'=1');
		$action_links = '<a href="'.$view_link.'">'.JText::_('COM_TABULIZER_VIEW').'</a> | <a href="'.$preview_link.'">'.JText::_('COM_TABULIZER_PREVIEW').'</a> | <a href="'.$edit_link.'">'.JText::_('COM_TABULIZER_EDIT').'</a> | <a href="'.$delete_link.'"  onclick="javascript:return confirm(\''.JText::_('COM_TABULIZER_DELETE_RULESET_CONFIRM').'\')">'.JText::_('COM_TABULIZER_DELETE').'</a>';
		echo '<tr class="row'.$k.'"><td>'.$checked.'</td><td><a href="'.$view_link.'">'.$row['title'].'</a></td><td>'.$row['name'].'</td><td>'.$row['suffix'].'</td><td>'.$row['style'].'</td><td>'.$ruleset_preselected.'</td><td>'.$action_links.'</td></tr>' ."\n";
		$i++;
	}
	?>
</table>			
<input type="hidden" name="option" value="<?php echo $option; ?>" />
<input type="hidden" name="task" value="" />
<input type="hidden" name="archive_filename" value="<?php echo htmlspecialchars($archive_filename,ENT_COMPAT,'UTF-8');?>" />
<input type="hidden" name="boxchecked" value="0"/>
<?php echo JHTML::_( 'form.token' ); ?>
</form>

<?php
} // if (empty($this->rulesets))

?>