<?php
/**
 * @version		2.0.0 tabulizer $
 * @package		tabulizer
 * @copyright	Copyright © 2011 - All rights reserved.
 * @license		GNU/GPL
 * @author		Dimitrios Mourloukos
 * @author mail	info@alterora.gr
 * @website		www.alterora.gr
 *
 *
 * @MVC architecture generated by MVC generator tool at http://www.alphaplug.com
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.view' );

class tabulizerViewRuleset extends JView
{
	function display($tpl = null){		
		$option = JRequest::getCmd('option');		
		
		$model = $this->getModel();
		$ruleset = $model->getRuleset();								
		
		if (!empty($ruleset)) {
			$this->assignRef('ruleset_name', $ruleset['name']);
			$this->assignRef('ruleset_title', $ruleset['title']);
			$this->assignRef('ruleset_description', $ruleset['description']);
			$this->assignRef('ruleset_style', $ruleset['style']);			
			$this->assignRef('ruleset_file', $ruleset['filename']);
			$this->assignRef('rules', $ruleset['rules']);
		}
		
		parent::display($tpl);
	}	
	
	function displayPreview($tpl = null) {
		$option = JRequest::getCmd('option');		
		
		$model = $this->getModel();
		$ruleset = $model->getRuleset();												
		
		if (!empty($ruleset)) {
			$this->assignRef('ruleset_name', $ruleset['name']);
			$this->assignRef('ruleset_title', $ruleset['title']);
			$this->assignRef('ruleset_description', $ruleset['description']);
			$this->assignRef('ruleset_style', $ruleset['style']);
			$this->assignRef('ruleset_style_inherited', $ruleset['style_inherited']);			
			$this->assignRef('ruleset_file', $ruleset['filename']);			
			$this->assignRef('rules', $ruleset['rules']);
			if (!empty($ruleset['sample_data'])) {
				$this->assignRef('sample_data_text', $ruleset['sample_data_text']);
				$this->assignRef('sample_data_sep', $ruleset['sample_data_sep']);				
				$this->assignRef('sample_data_enc', $ruleset['sample_data_enc']);				
			}
		}
		
		parent::display($tpl);
	}
	
	function displayNew($tpl = null) {
		$option = JRequest::getCmd('option');		
		
		$model = $this->getModel();
		$archive = $model->getRulesetArchive();									
		
		$ruleset_name = $model->getRecommendedName();
		$ruleset_suffix	= $ruleset_name;		
				
		$lists = array();	
												
		$lists['edit'] = false;
		
		$lists['name'] = '<input type="text" name="ruleset_name" id="ruleset_name" value="'.htmlspecialchars($ruleset_name,ENT_COMPAT,'UTF-8').'">';
		$lists['title'] = '<input type="text" name="ruleset_title" id="ruleset_title" value="">';
		$lists['description'] = '<input type="text" name="ruleset_description" id="ruleset_description" value="">';
		$lists['style'] = '<input type="text" name="ruleset_style" id="ruleset_style" value="">';
		$lists['suffix'] = '<input type="text" name="ruleset_suffix" id="ruleset_suffix" value="'.htmlspecialchars($ruleset_suffix,ENT_COMPAT,'UTF-8').'">';
		$lists['preselected'] = '<input type="checkbox" name="ruleset_preselected" id="ruleset_preselected" value="1"> ' . JText::_('COM_TABULIZER_YES');
		
		$sep_options = array(  SEPARATOR_COMMA => JText::_('COM_TABULIZER_COMMA_SEPARATOR'), 
							   SEPARATOR_SEMICOLON => JText::_('COM_TABULIZER_SEMICOLON_SEPARATOR'), 
							   SEPARATOR_ASTERISK => JText::_('COM_TABULIZER_ASTERISK_SEPARATOR'), 
							   SEPARATOR_CARET => JText::_('COM_TABULIZER_CARET_SEPARATOR'), 
							   SEPARATOR_SPACE => JText::_('COM_TABULIZER_SPACE_SEPARATOR'), 
							   SEPARATOR_TAB => JText::_('COM_TABULIZER_TAB_SEPARATOR'));
		$sample_data_sep_options = '';
		foreach ($sep_options as $key => $value) { $sample_data_sep_options .= '<option value="'.$key.'">'.$value.'</option>'; }					   
		
		
		$enc_options = array( ENCLOSURE_DOUBLE_QUOTES => JText::_('COM_TABULIZER_DOUBLE_QUOTES_ENCLOSURE'),
							  ENCLOSURE_SINGLE_QUOTES => JText::_('COM_TABULIZER_SINGLE_QUOTES_ENCLOSURE'),
							  ENCLOSURE_NONE => JText::_('COM_TABULIZER_NO_ENCLOSURE'));
		$sample_data_enc_options = '';					  
		foreach ($enc_options as $key => $value) { $sample_data_enc_options .= '<option value="'.$key.'">'.$value.'</option>'; }
		
		$lists['sample_data'] = '<input type="checkbox" name="sample_data_check" id="sample_data_check" value="1" onclick="updateSampleData(this);"> '  . JText::_('COM_TABULIZER_YES') . "<br/>\n" .
								'<span id="sample_data_span" class="hidden_span">' .								
								'<div style="padding-bottom: 15px;">' .
								'<em>'.JText::_('COM_TABULIZER_SAMPLE_DATA_TEXT').'</em><br/>' . 																
								'<textarea name="sample_data_text" id="sample_data_text" rows="10" ></textarea> <br/>' . 								
								'<em>'.JText::_('COM_TABULIZER_SAMPLE_DATA_SEP').'</em><br/>' . 								
								'<select name="sample_data_sep" id="sample_data_sep">'.$sample_data_sep_options.'</select><br/>' .			
								'<em>'.JText::_('COM_TABULIZER_SAMPLE_DATA_ENC').'</em><br/>' . 
								'<select name="sample_data_enc" id="sample_data_enc">'.$sample_data_enc_options.'</select>' .					
								'</div>' . 								
								'</span>';
		
		$ruleset_names = $model->getAllRulesetNames(array($ruleset_name));
		if (empty($ruleset_names)) {
			$lists['used_ruleset_names'] = '';
		} else {
			$lists['used_ruleset_names'] = '"'.implode('","', $ruleset_names).'"';
		}
		
		$ruleset_titles = $model->getAllRulesetTitles(array());
		if (empty($ruleset_titles)) {
			$lists['used_ruleset_titles'] = '';
		} else {
			$lists['used_ruleset_titles'] = '"'.implode('","', $ruleset_titles).'"';
		}
				
		$lists['filename'] = '<input type="hidden" name="archive_filename" value="'.htmlspecialchars($archive['filename'],ENT_COMPAT,'UTF-8').'" />';		
		$lists['filename_value'] = $archive['filename'];		
		
		$this->assignRef('lists', $lists);						
		
		parent::display($tpl);	
	}

	function displayEdit($tpl = null){		
		$option = JRequest::getCmd('option');		
		
		$model = $this->getModel();
		$ruleset = $model->getRuleset();											
		
		$lists = array();			
		
		$lists['edit'] = true;
		
		$lists['name'] = '<input type="text" name="ruleset_name" id="ruleset_name" value="'.htmlspecialchars($ruleset['name'],ENT_COMPAT,'UTF-8').'" readonly style="background-color: #c9c9c9">';
		$lists['title'] = '<input type="text" name="ruleset_title" id="ruleset_title" value="'.htmlspecialchars($ruleset['title'],ENT_COMPAT,'UTF-8').'">';
		$ruleset_description = empty($ruleset['description'])?'':$ruleset['description'];
		$lists['description'] = '<input type="text" name="ruleset_description" id="ruleset_description" value="'.htmlspecialchars($ruleset_description,ENT_COMPAT,'UTF-8').'">';
		$ruleset_style = empty($ruleset['style'])?'':$ruleset['style'];
		$lists['style'] = '<input type="text" name="ruleset_style" id="ruleset_style" value="'.htmlspecialchars($ruleset_style,ENT_COMPAT,'UTF-8').'">';
		$lists['suffix'] = '<input type="text" name="ruleset_suffix" id="ruleset_suffix" value="'.htmlspecialchars($ruleset['suffix'],ENT_COMPAT,'UTF-8').'">';
		if (!empty($ruleset['preselected'])) $preselected = 'checked'; else $preselected = '';
		$lists['preselected'] = '<input type="checkbox" name="ruleset_preselected" id="ruleset_preselected" value="1" '.$preselected.'> ' . JText::_('COM_TABULIZER_YES');		

		if (!empty($ruleset['sample_data'])) {
			$preselected = 'checked="checked"'; 
			$sample_data_span_class = '';
			$sample_data_text = $ruleset['sample_data_text'];
			$sample_data_sep = $ruleset['sample_data_sep'];
			$sample_data_enc = $ruleset['sample_data_enc'];
		} else { 
			$preselected = '';
			$sample_data_span_class = 'hidden_span';
			$sample_data_text = '';
			$sample_data_sep = '';
			$sample_data_enc = '';
		}			
		
		$sep_options = array(  SEPARATOR_COMMA => JText::_('COM_TABULIZER_COMMA_SEPARATOR'), 
							   SEPARATOR_SEMICOLON => JText::_('COM_TABULIZER_SEMICOLON_SEPARATOR'), 
							   SEPARATOR_ASTERISK => JText::_('COM_TABULIZER_ASTERISK_SEPARATOR'), 
							   SEPARATOR_CARET => JText::_('COM_TABULIZER_CARET_SEPARATOR'), 
							   SEPARATOR_SPACE => JText::_('COM_TABULIZER_SPACE_SEPARATOR'), 
							   SEPARATOR_TAB => JText::_('COM_TABULIZER_TAB_SEPARATOR'));
		$sample_data_sep_options = '';
		foreach ($sep_options as $key => $value) { if ($key == $sample_data_sep) $sample_data_sep_options .= '<option value="'.$key.'" selected="selected">'.$value.'</option>'; else $sample_data_sep_options .= '<option value="'.$key.'">'.$value.'</option>'; }
		
		$enc_options = array( ENCLOSURE_DOUBLE_QUOTES => JText::_('COM_TABULIZER_DOUBLE_QUOTES_ENCLOSURE'),
							  ENCLOSURE_SINGLE_QUOTES => JText::_('COM_TABULIZER_SINGLE_QUOTES_ENCLOSURE'),
							  ENCLOSURE_NONE => JText::_('COM_TABULIZER_NO_ENCLOSURE'));
		$sample_data_enc_options = '';					  
		foreach ($enc_options as $key => $value) { if ($key == $sample_data_enc) $sample_data_enc_options .= '<option value="'.$key.'" selected="selected">'.$value.'</option>'; else $sample_data_enc_options .= '<option value="'.$key.'">'.$value.'</option>'; }
		
		$lists['sample_data'] = '<input type="checkbox" name="sample_data_check" id="sample_data_check" value="1" '.$preselected.' onclick="updateSampleData(this);"> '  . JText::_('COM_TABULIZER_YES') . "<br/>\n" .								
								'<span id="sample_data_span" class="'.$sample_data_span_class.'">' .								
								'<div style="padding-bottom: 15px;">' .
								'<em>'.JText::_('COM_TABULIZER_SAMPLE_DATA_TEXT').'</em><br/>' . 
								'<textarea name="sample_data_text" id="sample_data_text" rows="10">'.$sample_data_text.'</textarea><br/>' . 
								'<em>'.JText::_('COM_TABULIZER_SAMPLE_DATA_SEP').'</em><br/>' . 								
								'<select name="sample_data_sep" id="sample_data_sep">'.$sample_data_sep_options.'</select><br/>' .								
								'<em>'.JText::_('COM_TABULIZER_SAMPLE_DATA_ENC').'</em><br/>' . 
								'<select name="sample_data_enc" id="sample_data_enc">'.$sample_data_enc_options.'</select>' .
								'</div>';								
								'</span>';
		
		$ruleset_names = $model->getAllRulesetNames(array($ruleset['name']));				
		
		if (empty($ruleset_names)) {
			$lists['used_ruleset_names'] = '';
		} else {
			$lists['used_ruleset_names'] = '"'.implode('","', $ruleset_names).'"';
		}			
		
		$ruleset_titles = $model->getAllRulesetTitles(array($ruleset['title']));
		if (empty($ruleset_titles)) {
			$lists['used_ruleset_titles'] = '';
		} else {
			$lists['used_ruleset_titles'] = '"'.implode('","', $ruleset_titles).'"';
		}			
		
		$lists['filename'] = '<input type="hidden" name="archive_filename" value="'.$ruleset['filename'].'" />';		
		$lists['filename_value'] = $ruleset['filename'];
		
		$this->assignRef('lists', $lists);						
		
		parent::display($tpl);
	}	

}
?>