<?php
/**
 * @package Tabulizer
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
**/

defined('_JEXEC') or die('Restricted access');

jimport('joomla.installer.installer');
jimport('joomla.installer.helper');
jimport('joomla.version');

class tabulizerInstallHelper {
	private $app = null;
	private $db = null;
	private $parent = null;
	private $status = null;
	private $legacy = false;
	private $installation_path = null;	

	public function __construct() {				
		$this->app = &JFactory::getApplication();
		$this->db = & JFactory::getDBO();
	
		$this->status = new JObject();
		$this->status->plugins = array();
		$this->status->extra = array();
		$this->status->texts = array();
		$this->status->operation = '';		
		
		$lang = &JFactory::getLanguage();
		$lang->load('com_tabulizer',JPATH_ADMINISTRATOR);				
				
		$installer = JInstaller::getInstance();
		$this->installation_path = $installer->_paths['source'];	
	}
	
	private function getPlugins($selection = 'new') {		
		$editor_plugin = array('name' => 'tabulizer', 'group'=> 'editors-xtd');
		$editor_plugin2 = array('name' => 'retabulizer', 'group'=> 'editors-xtd');
		$content_plugin = array('name' => 'tabulizercss', 'group'=> 'content');
		$system_plugin = array('name' => 'tabulizercss', 'group'=> 'system');
		$system_legacy_plugin = array('name' => 'tabulizercsslegacy', 'group'=> 'system');
				
		if ($selection == 'new') {				
			$plugins = array($editor_plugin, $editor_plugin2, $content_plugin, $system_plugin, $system_legacy_plugin);
		} else if ($selection == 'all') {
			$plugins = array($editor_plugin, $editor_plugin2, $content_plugin, $system_plugin, $system_legacy_plugin);
		}
		return $plugins;
	}

	private function installPlugins() {
			
		$plugins = $this->getPlugins('new');
			
		foreach ($plugins as $plugin) {		
			$name = $plugin['name'];
			$group = $plugin['group'];
			if (!empty($name) && !empty($group)) {
				$path = $this->installation_path.DS.'plugins'.DS.$group.DS.$name;									
				$query = "SELECT 1 FROM #__plugins WHERE element=".$this->db->Quote($name)." AND folder=".$this->db->Quote($group);
				$this->db->setQuery($query);
				$installed = $this->db->loadResult();								
				
				$installer = new JInstaller;
				$result = $installer->install($path);
				if ($result) {
					if ($installed) $text_result = JText::_('COM_TABULIZER_INSTALL_UPDATED');
					else $text_result = JText::_('COM_TABULIZER_INSTALL_INSTALLED');
				} else { 
					if ($installed) $text_result = JText::_('COM_TABULIZER_INSTALL_NOT_UPDATED');
					else $text_result = JText::_('COM_TABULIZER_INSTALL_NOT_INSTALLED');
				} 
				$this->status->plugins[] = array('name'=>$name, 'group'=>$group, 'result'=>$result, 'text_result'=>$text_result);
	
				if (!$installed) {
					$query = "UPDATE #__plugins SET published=1 WHERE element=".$this->db->Quote($name)." AND folder=".$this->db->Quote($group);
					$this->db->setQuery($query);
					$this->db->query();
				}								
				
				if (($name == 'tabulizercsslegacy') && ($group=='system') && (!$this->legacy)) {
					$query = "UPDATE #__plugins SET published=0 WHERE element=".$this->db->Quote($name)." AND folder=".$this->db->Quote($group);
					$this->db->setQuery($query);
					$this->db->query();
				}
	
			}
		}	
		
	}

  	public function install() {
		
		$this->status->operation = 'install';
		$this->status->texts['ok'] = JText::_('COM_TABULIZER_INSTALL_INSTALLED');
		$this->status->texts['ko'] = JText::_('COM_TABULIZER_INSTALL_NOT_INSTALLED');
		$this->status->texts['heading'] = JText::_('COM_TABULIZER_INSTALL_INSTALL_HEADING');								
		
		$this->prepareTabulizerInstallation();
				
		$this->installPlugins();
		
		$this->postflight();
  	}

	private function uninstallPlugins() {
		$plugins = $this->getPlugins('new');
			
		foreach ($plugins as $plugin) {		
			$name = $plugin['name'];
			$group = $plugin['group'];
			
			if (!empty($name) && !empty($group)) {
				$query = "SELECT id FROM #__plugins WHERE folder=".$this->db->Quote($group)." and element=".$this->db->Quote($name)."";	
				$this->db->setQuery($query);
				$db_plugins = $this->db->loadResultArray();
				$result = false;
				if (count($db_plugins)) {
					$result = true;
					foreach ($db_plugins as $db_plugin) {
						$installer = new JInstaller;
						$result = $installer->uninstall('plugin', $db_plugin, 0) && $result;
					}
				}
				if ($result) $text_result = JText::_('COM_TABULIZER_INSTALL_REMOVED');
				else $text_result = JText::_('COM_TABULIZER_INSTALL_NOT_REMOVED');
				$this->status->plugins[] = array ('name'=>$name, 'group'=>$group, 'result'=>$result, 'text_result'=>$text_result);
			}
		}

	}
	
	/**
	This is a Tabulizer only process that takes care of two things:
	1. Creates the joomla library folder specific for Tabulizer, if it does not exist.
	2. Checks to see if a previous (legacy) installation has rules and css files that need to be moved to the Tabulizer library folder
	*/
	private function prepareTabulizerInstallation() {	
	
		# check to see if the Tabulizer library folder already exists. If not, create it
		$library_path = JPATH_SITE . DS . 'templates' . DS.  'tabulizer';
			
		if (!file_exists($library_path)) {
			$new_directories = array(
				$library_path, $library_path . DS . 'rules', $library_path . DS . 'css', $library_path . DS . 'images', $library_path . DS . 'uploads',
				$library_path . DS. 'legacy', $library_path . DS. 'legacy' . DS . 'rules', $library_path . DS. 'legacy' . DS . 'css', $library_path . DS. 'legacy' . DS . 'images'
			);
			foreach ($new_directories as $new_directory) {				
				$result = @mkdir($new_directory, 0755, true);
				if (!$result) {																				
					$this->status->extra[] = array('name'=>JText::_('COM_TABULIZER_INSTALL_LIBRARY'),'result'=>false, 'text_result'=> JText::_('COM_TABULIZER_INSTALL_NOT_CREATED'));
					$msg = sprintf(JText::_('COM_TABULIZER_INSTALL_WRONG_DIR_PERMISSIONS'),$new_directory);					
					JError::raiseWarning( 101, $msg );	
					return false;
				}				
			}
			$this->status->extra[] = array('name'=>JText::_('COM_TABULIZER_INSTALL_LIBRARY'),'result'=>true, 'text_result'=> JText::_('COM_TABULIZER_INSTALL_CREATED'));
		}
		
		# check to see if you need to move rulesets compatible with Tabulizer 2.5 to the new location
		$old_library_path = JPATH_LIBRARIES . DS . 'alterora/tabulizer';				
		$old_library_dirs = array($old_library_path. DS . 'rules' => $library_path . DS . 'rules',
							$old_library_path. DS . 'css' => $library_path . DS . 'css',
							$old_library_path. DS . 'images' => $library_path . DS . 'images');
		foreach ($old_library_dirs as $old_dir => $new_dir) {
			if (file_exists($old_dir)) {
				$old_moved = true;
				// copy all files
				if ($handle = opendir($old_dir)) {									
					while (false !== ($entry = readdir($handle))) {
						if (($entry != '.') && ($entry != '..')) {
							$source_file = $old_dir . DS . $entry;
							$destination_file = $new_dir . DS . $entry;
							if (is_file($source_file) && !file_exists($destination_file)) {
								$result = @copy($source_file, $destination_file);
								if (!$result) {
									$this->status->extra[] = array('name'=>JText::_('COM_TABULIZER_INSTALL_LIBRARY_OLD'),'result'=>false, 'text_result'=> JText::_('COM_TABULIZER_INSTALL_NOT_MOVED'));
									$msg = sprintf(JText::_('COM_TABULIZER_INSTALL_WRONG_FILE_PERMISSIONS'),$destination_file);
									JError::raiseWarning( 101, $msg );	
									return false;
								}
							}
						}
					}								
					closedir($handle);
				}													
			}
		}								
	
		# check to see if you need to create a legacy directory and activate the related system plugin
		$legacy_path = JPATH_PLUGINS. DS .'editors-xtd'. DS. 'tabulizer';
		$legacy_dirs = array($legacy_path. DS . 'rules' => $library_path . DS . 'legacy' .DS. 'rules',
							$legacy_path. DS . 'css' => $library_path . DS . 'legacy' .DS. 'css',
							$legacy_path. DS . 'images' => $library_path . DS . 'legacy' .DS. 'images');
		
		$legacy_moved = false;
							
		foreach ($legacy_dirs as $legacy_dir => $new_dir) {
			if (file_exists($legacy_dir)) {
				$legacy_moved = true;
				// copy all files
				if ($handle = opendir($legacy_dir)) {									
					while (false !== ($entry = readdir($handle))) {
						if (($entry != '.') && ($entry != '..')) {
							$source_file = $legacy_dir . DS . $entry;
							$destination_file = $new_dir . DS . $entry;
							if (is_file($source_file) && !file_exists($destination_file)) {
								$result = @copy($source_file, $destination_file);
								if (!$result) {
									$this->status->extra[] = array('name'=>JText::_('COM_TABULIZER_INSTALL_LIBRARY_LEGACY'),'result'=>false, 'text_result'=> JText::_('COM_TABULIZER_INSTALL_NOT_MOVED'));
									$msg = sprintf(JText::_('COM_TABULIZER_INSTALL_WRONG_FILE_PERMISSIONS'),$destination_file);
									JError::raiseWarning( 101, $msg );	
									return false;
								}
							}
						}
					}								
					closedir($handle);
				}								
			} else if (file_exists($new_dir)) {
				// check if the folder are empty
				if ($handle = opendir($new_dir)) {									
					while (false !== ($entry = readdir($handle))) {
						if (($entry != '.') && ($entry != '..')) {
							$source_file = $new_dir . DS . $entry;
							if (is_file($source_file)){
								$this->legacy = true;
								break;
							}
						}
					}								
					closedir($handle);
				}				
			}
		}	
		
		if ($legacy_moved) {
			$this->legacy = true;						
			$this->status->extra[] = array('name'=>JText::_('COM_TABULIZER_INSTALL_LIBRARY_LEGACY'),'result'=>true, 'text_result'=> JText::_('COM_TABULIZER_INSTALL_MOVED'));
		}							
		
		# uninstall the rest of plugins from previous installations (if present) 
		$plugins = $this->getPlugins('all');
		foreach ($plugins as $plugin) {		
			$name = $plugin['name'];
			$group = $plugin['group'];
			if (!empty($name) && !empty($group)) {
				$query = "SELECT id FROM #__plugins WHERE folder=".$this->db->Quote($group)." and element=".$this->db->Quote($name)."";					
				$this->db->setQuery($query);
				$db_plugins = $this->db->loadResultArray();					
				if (count($db_plugins)) {
					$result = true;
					foreach ($db_plugins as $db_plugin) {
						$installer = new JInstaller;
						$result = $installer->uninstall('plugin', $db_plugin, 0) && $result;
					}					
					if ($result) $text_result = JText::_('COM_TABULIZER_INSTALL_REMOVED');
					else $text_result = JText::_('COM_TABULIZER_INSTALL_NOT_REMOVED');
					$this->status->plugins[] = array ('name'=>$name, 'group'=>$group, 'result'=>$result, 'text_result'=>$text_result);						
				}					
			}
		}
				
		return true;
	}
	
	private function installNewRulesets() {
		$library_path = JPATH_SITE . DS . 'templates' . DS.  'tabulizer';				
		
		# install new rulesets that came with the installation distribution (may override previous ones)
		$installation_rulesets_dir = JPATH_ADMINISTRATOR . DS. 'components/com_tabulizer/assets/rulesets/';		
		$installation_dirs = array($installation_rulesets_dir . 'rules' => $library_path . DS . 'rules',
							$installation_rulesets_dir . 'css' => $library_path . DS . 'css',
							$installation_rulesets_dir . 'images' => $library_path . DS . 'images',
							$installation_rulesets_dir . 'uploads' => $library_path . DS . 'uploads');

		$new_moved = false;
		foreach ($installation_dirs as $installation_dir => $new_dir) {			
			if (file_exists($installation_dir)) {
				$new_moved = true;
				// copy all files
				if ($handle = opendir($installation_dir)) {									
					while (false !== ($entry = readdir($handle))) {
						if (($entry != '.') && ($entry != '..')) {
							$source_file = $installation_dir . DS . $entry;
							$destination_file = $new_dir . DS . $entry;
							if (is_file($source_file) && !file_exists($destination_file)) {
								$result = @copy($source_file, $destination_file);
								if (!$result) {
									$this->status->extra[] = array('name'=>JText::_('COM_TABULIZER_INSTALL_NEW_RULESETS'),'result'=>false, 'text_result'=> JText::_('COM_TABULIZER_INSTALL_NOT_INSTALLED'));
									$msg = sprintf(JText::_('COM_TABULIZER_INSTALL_WRONG_FILE_PERMISSIONS'),$destination_file);
									JError::raiseWarning( 101, $msg );	
									return false;
								}
							}
						}
					}								
					closedir($handle);
				}
								
			}
		}	
		  
		if ($new_moved) {
			$this->status->extra[] = array('name'=>JText::_('COM_TABULIZER_INSTALL_NEW_RULESETS'),'result'=>true, 'text_result'=> JText::_('COM_TABULIZER_INSTALL_INSTALLED'));
		}
	
	}

	public function uninstall() {		
		$this->status->operation = 'uninstall';
		$this->status->texts['ok'] = JText::_('COM_TABULIZER_INSTALL_REMOVED');
		$this->status->texts['ko'] = JText::_('COM_TABULIZER_INSTALL_NOT_REMOVED');
		$this->status->texts['heading'] = JText::_('COM_TABULIZER_INSTALL_UNINSTALL_HEADING');
		
		$this->uninstallPlugins();
		
		$this->displayStatus();
	}
	
	public function update() {								
		$this->status->operation = 'update';
		$this->status->texts['ok'] = JText::_('COM_TABULIZER_INSTALL_UPDATED');
		$this->status->texts['ko'] = JText::_('COM_TABULIZER_INSTALL_NOT_UPDATED');
		$this->status->texts['heading'] = JText::_('COM_TABULIZER_INSTALL_UPDATE_HEADING');				
		
		$this->prepareTabulizerInstallation();
				
		$this->installPlugins();
		
		$this->postflight();
	}	

	public function postflight() {    
		$this->installNewRulesets();
		$this->displayStatus();
	}

	private function displayStatus() {
		$k = 0;
		$status = &$this->status;		
?>
<h2><?php echo $status->texts['heading']; ?></h2>
<table class="adminlist">
	<thead>
		<tr>
			<th class="title" colspan="2"><?php echo JText::_('COM_TABULIZER_INSTALL_EXTENSION'); ?></th>
			<th width="30%" align="center"><?php echo JText::_('COM_TABULIZER_INSTALL_STATUS'); ?></th>
		</tr>
	</thead>
	<tbody>
		<tr class="row0">
			<td class="key" colspan="2"><?php echo JText::_('COM_TABULIZER_INSTALL_COMPONENT'); ?></td>
			<td><strong style="color: green;"><?php echo $status->texts['ok']; ?></strong></td>
		</tr>
		<?php if (count($status->plugins)) { ?>
		<tr class="row<?php echo (++$k % 2); ?>">
			<th><?php echo JText::_('COM_TABULIZER_INSTALL_PLUGIN'); ?></th>
			<th><?php echo JText::_('COM_TABULIZER_INSTALL_GROUP'); ?></th>
			<th>&nbsp;</th>
		</tr>
		<?php foreach ($status->plugins as $plugin) { ?>
		<tr class="row<?php echo (++$k % 2); ?>">
			<td class="key"><?php echo $plugin['name']; ?></td>
			<td class="key"><?php echo $plugin['group']; ?></td>
			<td><strong style="color: <?php echo ($plugin['result']) ? 'green' : 'red' ?>;"><?php echo $plugin['text_result']; ?></strong></td>
		</tr>
		<?php } ?>
		<?php } ?>
		<?php if (count($status->extra)) { ?>
		<tr class="row<?php echo (++$k % 2); ?>">
			<th colspan=2><?php echo JText::_('COM_TABULIZER_INSTALL_EXTRA'); ?></th>
			<th>&nbsp;</th>
		</tr>
		<?php foreach ($status->extra as $extra) { ?>
		<tr class="row<?php echo (++$k % 2); ?>">
			<td class="key" colspan="2"><?php echo $extra['name']; ?></td>
			<td><strong style="color: <?php echo ($extra['result']) ? 'green' : 'red' ?>;"><?php echo $extra['text_result']; ?></strong></td>
		</tr>
		<?php } ?>
		<?php } ?>
	</tbody>
</table>
<?php		
	}
}
?>