<?php
/**
 * @version		2.0.0 tabulizer $
 * @package		tabulizer
 * @copyright	Copyright © 2011 - All rights reserved.
 * @license		GNU/GPL
 * @author		Dimitrios Mourloukos
 * @author mail	info@alterora.gr
 * @website		www.alterora.gr
 *
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controller');

class tabulizerController extends JController
{
	/**
	 * Custom Constructor
	 */

	function __construct()
	{
		parent::__construct();				
		require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'assets'.DS.'classes'.DS.'message.php');
	}
	
	function display( )
	{		
		$this->viewRulesetArchives();
	}
	
	//=============================================================================================
	// DIALOG
	//=============================================================================================
	
	function dialog() {
		require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'assets'.DS.'classes'.DS.'dialog'.DS.'dialog.php');
	}
		
	function convert() {
		require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'assets'.DS.'classes'.DS.'dialog'.DS.'convert.php');
	}
	
	function extract_table_data() {
		require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'assets'.DS.'classes'.DS.'dialog'.DS.'extract_table_data.php');
	}
	
	function extract_excel_data() {
		require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'assets'.DS.'classes'.DS.'dialog'.DS.'extract_excel_data.php');
	}
	
	function upload_excel_file() {
		require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'assets'.DS.'classes'.DS.'dialog'.DS.'upload_excel_file.php');
	}
		
	//=============================================================================================
	// RULESET ARCHIVES
	//=============================================================================================	
	
	function viewRulesetArchives() {
		$option = JRequest::getCmd('option');				
		
		$model = &$this->getModel('rulesetarchives');			
		$view = &$this->getView('rulesetarchives','html');
								
		$editor_pugin_installed = $model->isEditorPluginInstalled();
		if ($editor_pugin_installed) {
			$model->loadRulesetArchives();				
			
			$view->setModel($model, true);
			$view->setLayout('default');
			$view->display();							
		} else {
			$msg = JText::_('COM_TABULIZER_EDITOR_PLUGIN_NOT_INSTALLED');
			TabulizerUserMessage::printInfo($msg);	
		}
	}
	
	//=============================================================================================
	// RULESET ARCHIVE
	//=============================================================================================		
	
	function viewRulesetArchive() {
		$option = JRequest::getCmd('option');
		
		$archive_filename = JRequest::getString( 'archive_filename', '' );
		
		if (empty($archive_filename)) {
			$msg = JText::_('COM_TABULIZER_NO_RULESET_ARCHIVE_IS_SPECIFIED');
			$link =  'index.php?option='. $option;
			$this->setRedirect($link, $msg);
		} else {
			$model = &$this->getModel('rulesetarchive');			
			$view = &$this->getView('rulesetarchive','html');
			$ruleset_archive = $model->loadRulesetArchive($archive_filename);
			if (empty($ruleset_archive)) {
				$msg = JText::_('COM_TABULIZER_SPECIFIED_RULESET_ARCHIVE_IS_EMPTY_OR_NOT_FOUND');
				$link =  'index.php?option='. $option;
				$this->setRedirect($link, $msg);
			} else {			
				$view->setModel($model, true);
				$view->setLayout('default');
				$view->display();					
			}			
		}
						
	}	
	
	function viewRulesetArchivePreview() {
		$option = JRequest::getCmd('option');
		
		$archive_filename = JRequest::getString( 'archive_filename', '' );
		
		if (empty($archive_filename)) {
			$msg = JText::_('COM_TABULIZER_NO_RULESET_ARCHIVE_IS_SPECIFIED');
			$link =  'index.php?option='. $option;
			$this->setRedirect($link, $msg);
		} else {
			$model = &$this->getModel('rulesetarchive');			
			$view = &$this->getView('rulesetarchive','html');
			$ruleset_archive = $model->loadRulesetArchive($archive_filename);
			if (empty($ruleset_archive)) {
				$msg = JText::_('COM_TABULIZER_SPECIFIED_RULESET_ARCHIVE_IS_EMPTY_OR_NOT_FOUND');
				$link =  'index.php?option='. $option;
				$this->setRedirect($link, $msg);
			} else {			
				$view->setModel($model, true);
				$view->setLayout('preview');
				$view->displayPreview();					
			}			
		}
						
	}	
	
	
	function newRulesetArchive() {
		$option = JRequest::getCmd('option');								
		
		$model = &$this->getModel('rulesetarchive');			
		$view = &$this->getView('rulesetarchive','html');												

		$view->setModel($model, true);
		$view->setLayout('form');				
		$view->displayNew();		
	}	
	
	function editRulesetArchive() {
		$option = JRequest::getCmd('option');		
		
		$ruleset_file = JRequest::getString( 'archive_filename', '' );		

		if (empty($ruleset_file)) {
			$msg = JText::_('COM_TABULIZER_NO_RULESET_ARCHIVE_IS_SPECIFIED');
			$link =  'index.php?option='. $option;
			$this->setRedirect($link, $msg);
		} else {
			$model = &$this->getModel('rulesetarchive');			
			$view = &$this->getView('rulesetarchive','html');			
			
			$archive = $model->loadRulesetArchive($ruleset_file);
			if (empty($archive)) {
				$msg = JText::_('COM_TABULIZER_SPECIFIED_RULESET_ARCHIVE_IS_EMPTY_OR_NOT_FOUND');
				$link =  'index.php?option='. $option;
				$this->setRedirect($link, $msg);
			} else {			
				$view->setModel($model, true);
				$view->setLayout('form');
				$view->displayEdit();					
			}			
		}				
	}
	
	function saveRulesetArchive() {
		$option = JRequest::getCmd('option');			
		
		$ruleset_file = JRequest::getString( 'archive_filename', '' );		
		$link = 'index.php?option='. $option;																									
		
		if (empty($ruleset_file)) {
			$msg = JText::_('COM_TABULIZER_INVALID_ARGS');					
		} else {
			$regex = '/^([a-zA-Z0-9\._\-]{2,128})\\.xml$/i';
			if (preg_match($regex, $ruleset_file, $matches)) {		
				$ruleset_file = $matches[1];											
				$model = &$this->getModel('rulesetarchive');			
				$ruleset_archive = array('name'=>JRequest::getVar('archive_name', null), 'title'=>JRequest::getVar('archive_title',null), 'style'=>JRequest::getVar('archive_style',null));			
				if ($model->saveRulesetArchive($ruleset_archive, $ruleset_file)) {
					$msg = JText::_('COM_TABULIZER_RULESET_ARCHIVE_SAVED_SUCCESSFULLY');
				} else {
					$msg = JText::_('COM_TABULIZER_COULD_NOT_SAVE_RULESET_ARCHIVE');				
				}						
			} else {							
				$msg = JText::_('COM_TABULIZER_INVALID_RULESET_ARCHIVE_FILENAME');		
				$this->setRedirect($link, $msg);
			}
		}				
						
		$this->setRedirect($link, $msg);
	}
	
	function deleteRulesetArchive() {
		$option = JRequest::getCmd('option');				
		
		$link = 'index.php?option='. $option;						
		$cid = JRequest::getVar( 'cid', array(0), 'request', 'array' );									
		
	    if (count( $cid )) {						
			$model = &$this->getModel('rulesetarchive');												
			if ($model->deleteRulesetArchive($cid)) {
				$msg = JText::_('COM_TABULIZER_SELECTED_RULESET_ARCHIVES_DELETED_SUCCESSFULLY');
			} else {
				$msg = JText::_('COM_TABULIZER_RULESET_ARCHIVES_DELETION_FAILED');
			}			
		} else {
			$msg = JText::_('COM_TABULIZER_NO_RULESET_ARCHIVES_SELECTED_FOR_DELETION');
		}
		
		$this->setRedirect($link, $msg);						
	}	
	
	function exportRulesetArchiveCSS() {
		$option = JRequest::getCmd('option');				
		
		$link = 'index.php?option='. $option;						
		$cid = JRequest::getVar( 'cid', array(0), 'request', 'array' );									
		
	    if (count( $cid )) {						
			$model = &$this->getModel('rulesetarchives');										
			$view = &$this->getView('rulesetarchives','html');
			$css_code = $model->exportRulesetArchivesSkeletonCSSCode( $cid );						
			if (empty($css_code)) {
				$msg = JText::_('COM_TABULIZER_SPECIFIED_RULESET_ARCHIVES_DO_NOT_CONTAIN_RULES_TO_EXPORT_OR_NOT_FOUND');
				$this->setRedirect($link, $msg);	
			} else {
				$view->setModel($model, true);
				$view->setLayout('export');
				$view->displayExport();			
			}
		} else {
			$msg = JText::_('COM_TABULIZER_NO_RULESET_ARCHIVES_SELECTED_FOR_CSS_EXPORT');
			$this->setRedirect($link, $msg);	
		}		
									
	}
		
	function importRulesetArchive() {
		$option = JRequest::getCmd('option');	
		$link = 'index.php?option='. $option;
								
		$importFileData = JRequest::getVar( 'import_file', 0);
		$displayForm = ($importFileData)?false:true;
		
		if ($displayForm) {
			$model = &$this->getModel('rulesetarchives');										
			$view = &$this->getView('rulesetarchives','html');									
			$view->setModel($model, true);
			$view->setLayout('import');				
			$view->displayImport();		
			return;
		}				
	
		//import joomlas filesystem functions, we will do all the filewriting with joomlas functions,
		//so if the ftp layer is on, joomla will write with that, not the apache user, which might
		//not have the correct permissions
		jimport('joomla.filesystem.file');
		jimport('joomla.filesystem.folder');
		 
		//this is the name of the field in the html form, filedata is the default name for swfupload
		//so we will leave it as that
		$fieldName = 'zip_filename';
		 
		//any errors the server registered on uploading
		$fileError = $_FILES[$fieldName]['error'];
		if ($fileError > 0) {
			switch ($fileError) {
				case 1:
					$msg = JText::_( 'COM_TABULIZER_FILE_UPLOAD_LARGER_THAN_PHP_INI_ALLOWS' );
					break;		 
				case 2:
					$msg = JText::_( 'COM_TABULIZER_FILE_UPLOAD_LARGER_THAN_HTML_FORM_ALLOWS' );
					break;		 
				case 3:
					$msg = JText::_( 'COM_TABULIZER_FILE_UPLOAD_ERROR_PARTIAL' );
					break;		 
				case 4:
					$msg = JText::_( 'COM_TABULIZER_FILE_UPLOAD_ERROR_NO_FILE' );
					break;
				default:
					$msg = JText::_( 'COM_TABULIZER_FILE_UPLOAD_ERROR_UNKNOWN' );
					break;
						
			}
			$this->setRedirect($link, $msg);	
			return;
		}
		 
		//check for filesize		
		$fileSize = $_FILES[$fieldName]['size'];
		$maxAllowedFileSize = 20000000;
		if($fileSize > $maxAllowedFileSize)
		{
			$msg = JText::_( 'COM_TABULIZER_FILE_UPLOAD_LARGER_THAN_COMPONENT_ALLOWS' );
			$this->setRedirect($link, $msg);	
			return;
		}
		 
		//check the file extension is ok
		$fileName = $_FILES[$fieldName]['name'];
		$uploadedFileNameParts = explode('.',$fileName);
		$uploadedFileExtension = array_pop($uploadedFileNameParts);
		 
		$validFileExts = array('zip');
		 
		//assume the extension is false until we know its ok
		$extOk = false;
		 
		//go through every ok extension, if the ok extension matches the file extension (case insensitive)
		//then the file extension is ok
		foreach($validFileExts as $key => $value)
		{
			if( preg_match("/$value/i", $uploadedFileExtension ) )
			{
				$extOk = true;
			}
		}
		 
		if ($extOk == false) 
		{
			$msg = sprintf(JText::_( 'COM_TABULIZER_FILE_UPLOAD_INVALID_EXTENSION' ),implode(',',$validFileExts));
			$this->setRedirect($link, $msg);	
			return;
		}
		 
		//the name of the file in PHP's temp directory that we are going to move to our folder
		$fileTemp = $_FILES[$fieldName]['tmp_name'];
		
		//lose any special characters in the filename
		$fileName = ereg_replace("[^A-Za-z0-9._]", "-", $fileName);		 
		 
		//always use constants when making file paths, to avoid the possibilty of remote file inclusion
		$uploadPath = JPATH_SITE . DS . RULES_UPLOAD_DIR . $fileName; 
		$unzipPath = JPATH_SITE . DS . RULES_DIR; 				
		
		$overwrite = JRequest::getVar( 'overwrite_file', 0);
		if (file_exists($uploadPath)) {			
			unlink($uploadPath);
			/*
			if ($overwrite) {
				unlink($uploadPath);
			} else {
				$msg = sprintf(JText::_( 'COM_TABULIZER_FILE_UPLOAD_FILE_ALREADY_EXISTS' ),$fileName,$uploadPath);
				$this->setRedirect($link, $msg);	
				return;			
			}
			*/
		}			 
		if(!JFile::upload($fileTemp, $uploadPath)) 
		{			
			$msg = sprintf(JText::_( 'COM_TABULIZER_FILE_UPLOAD_UNABLE_TO_UNZIP_FILE' ),$fileName);
			$this->setRedirect($link, $msg);	
			return;
		}
		else
		{			
		    // unzip file
			if (!class_exists('ZipArchive')) {
				$css_dir = JPATH_SITE.DS.'templates'.DS.'tabulizer'.DS.'css';
				$rules_dir = JPATH_SITE.DS.'templates'.DS.'tabulizer'.DS.'rules';			
				$msg = sprintf(JText::_( 'COM_TABULIZER_FILE_UPLOAD_ZIP_LIBRARY_MISSING'), $css_dir, $rules_dir);							
				$this->setRedirect($link, $msg);	
				return;	
			}	
			
		    $zip = new ZipArchive;
			if ($zip->open($uploadPath)) {
				$success = true;
				for ($i=0; $i<$zip->numFiles;$i++) {
					$entry_info = $zip->statIndex($i);
					$filename = $unzipPath . $entry_info['name'];
					if (file_exists($filename) && !$overwrite) {
						if (!is_dir($filename)) {
							$msg = sprintf(JText::_( 'COM_TABULIZER_FILE_UPLOAD_FILE_EXTRACT_ALREADY_EXISTS' ),$fileName,$entry_info['name'],$unzipPath);
							$success = false;
							break;
						}						
					}									    
				}
				if ($success) {					
					if ($zip->extractTo($unzipPath)) {
						$msg = sprintf(JText::_( 'COM_TABULIZER_FILE_UPLOAD_SUCCESS'),$fileName);
					} else {
						$msg = sprintf(JText::_( 'COM_TABULIZER_FILE_UPLOAD_UNABLE_TO_EXTRACT_FILE' ),$fileName,$unzipPath);
					}					
				}	
				$zip->close();	
				$this->setRedirect($link, $msg);	
				return;				
			} else {
				$msg = sprintf(JText::_( 'COM_TABULIZER_FILE_UPLOAD_UNABLE_TO_UNZIP_FILE' ),$fileName);
				$this->setRedirect($link, $msg);	
				return;				
			}
									   		   		   
		}

	}
			
	//=============================================================================================
	// RULESET
	//=============================================================================================		
	
	function getRulesetArgs(&$ruleset_name, &$ruleset_file) {
		$ruleset_name = JRequest::getString( 'ruleset_name', '' );
		$ruleset_file = JRequest::getString( 'archive_filename', '' );		

		if (empty($ruleset_file)) {
			$msg = JText::_('COM_TABULIZER_NO_RULESET_ARCHIVE_IS_SPECIFIED');
			$link =  'index.php?option='. $option;
			$this->setRedirect($link, $msg);
		} else if (empty($ruleset_name)) {
			$msg = JText::_('COM_TABULIZER_NO_RULESET_NAME_IS_SPECIFIED');
			$link =  'index.php?option='. $option;
			$this->setRedirect($link, $msg);
		} else {
			return true;
		}
		
		return false;
	}
	
	function viewRuleset() {
		$option = JRequest::getCmd('option');
		
		if ($this->getRulesetArgs($ruleset_name, $ruleset_file)) {	
			$model = &$this->getModel('ruleset');			
			$view = &$this->getView('ruleset','html');												
			$ruleset = $model->loadRuleset($ruleset_name, $ruleset_file);
			if (empty($ruleset)) {
				$msg = JText::_('COM_TABULIZER_SPECIFIED_RULESET_IS EMPTY_OR_NOT_FOUND');
				$link =  'index.php?option='. $option;
				$this->setRedirect($link, $msg);
			} else {			
				$view->setModel($model, true);
				$view->setLayout('default');
				$view->display();					
			}					
		} else {
			$msg = JText::_('COM_TABULIZER_INVALID_ARGS');				
			$redirect_link =  'index.php?option='. $option;			
			$this->setRedirect($redirect_link, $msg);
		}			
								
	}	
	
	function viewRulesetPreview() {
		$option = JRequest::getCmd('option');				
		
		if ($this->getRulesetArgs($ruleset_name, $ruleset_file)) {						
			$model = &$this->getModel('ruleset');			
			$view = &$this->getView('ruleset','html');												
			$ruleset = $model->loadRuleset($ruleset_name, $ruleset_file);
			if (empty($ruleset)) {
				$msg = JText::_('COM_TABULIZER_SPECIFIED_RULESET_IS_EMPTY_OR_NOT_FOUND');
				$link =  'index.php?option='. $option;
				$this->setRedirect($link, $msg);
			} else {														
				$view->setModel($model, true);
				$view->setLayout('preview');
				$view->displayPreview();					
			}					
		} else {
			$msg = JText::_('COM_TABULIZER_INVALID_ARGS');				
			$redirect_link =  'index.php?option='. $option;			
			$this->setRedirect($redirect_link, $msg);
		}			
		
	}
	
	function newRuleset() {
		$option = JRequest::getCmd('option');				
		
		$ruleset_file = JRequest::getString( 'archive_filename', '' );
		
		if (empty($ruleset_file)) {
			$msg = JText::_('COM_TABULIZER_NO_RULESET_ARCHIVE_IS_SPECIFIED');
			$link =  'index.php?option='. $option;
			$this->setRedirect($link, $msg);
		} else {
			$model = &$this->getModel('rulesetarchive');			
			$view = &$this->getView('ruleset','html');												
			$archive = $model->loadRulesetArchive($ruleset_file);
			if (empty($archive)) {
				$msg = JText::_('COM_TABULIZER_SPECIFIED_RULESET_ARCHIVE_IS_EMPTY_OR_NOT_FOUND');
				$link =  'index.php?option='. $option;
				$this->setRedirect($link, $msg);
			} else {			
				$view->setModel($model, true);
				$view->setLayout('form');
				$view->displayNew();
			}			
		}
		
	}	
	
	function editRuleset() {
		$option = JRequest::getCmd('option');		
		
		if ($this->getRulesetArgs($ruleset_name, $ruleset_file)) {						
			$model = &$this->getModel('ruleset');			
			$view = &$this->getView('ruleset','html');															
						
			$ruleset = $model->loadRuleset($ruleset_name, $ruleset_file);
			if (empty($ruleset)) {
				$msg = JText::_('COM_TABULIZER_SPECIFIED_RULESET_IS_EMPTY_OR_NOT_FOUND');
				$link =  'index.php?option='. $option;
				$this->setRedirect($link, $msg);
			} else {			
				$view->setModel($model, true);
				$view->setLayout('form');
				$view->displayEdit();					
			}								
		} else {
			$msg = JText::_('COM_TABULIZER_INVALID_ARGS');				
			$redirect_link =  'index.php?option='. $option;			
			$this->setRedirect($redirect_link, $msg);
		}				

	}
	
	function saveRuleset() {
		$option = JRequest::getCmd('option');								
		
		if ($this->getRulesetArgs($ruleset_name, $ruleset_file)) {
			$redirect_link = 'index.php?option='.$option.'&task=viewrulesetarchive&archive_filename='.$ruleset_file;
			$ruleset = array('name'=> JRequest::getVar('ruleset_name', null), 'title'=>JRequest::getVar('ruleset_title', null), 'description'=>JRequest::getVar('ruleset_description', null), 'suffix'=> JRequest::getVar('ruleset_suffix', null), 'style'=> JRequest::getVar('ruleset_style', null), 'preselected' => JRequest::getVar('ruleset_preselected', null), 'filename' => $ruleset_file);						
			$sample_date = JRequest::getVar('sample_data_check', 0);
			if (!empty($sample_date)) {
				$sample_data_text = JRequest::getVar('sample_data_text', null);
				$sample_data_sep = JRequest::getVar('sample_data_sep', null);
				$sample_data_enc = JRequest::getVar('sample_data_enc', null);
				if (!empty($sample_data_text) && !empty($sample_data_sep)) {					
					$ruleset['sample_data'] = 1;
					$ruleset['sample_data_text'] = $sample_data_text;
					$ruleset['sample_data_sep'] = $sample_data_sep;
					$ruleset['sample_data_enc'] = $sample_data_enc;
				}								
			}							
															
			$model = &$this->getModel('ruleset');
			if ($model->saveRuleset($ruleset, $ruleset_file)) {
				$msg = JText::_('COM_TABULIZER_RULESET_SAVED_SUCCESSFULLY');
			} else {
				$msg = JText::_('COM_TABULIZER_COULD_NOT_SAVE_RULESET');				
			}			
		} else {
			$msg = JText::_('COM_TABULIZER_INVALID_ARGS');				
			$redirect_link =  'index.php?option='. $option;			
		}
		
		$this->setRedirect($redirect_link, $msg);
	}
	
	function deleteRuleset() {
		$option = JRequest::getCmd('option');				
		
		$cid = JRequest::getVar( 'cid', array(0), 'request', 'array' );						
		
	    if (count( $cid )) {			
			$ruleset_file = JRequest::getString( 'archive_filename', '' );			
			if (empty($ruleset_file)) {
				$msg = JText::_('COM_TABULIZER_NO_RULESET_ARCHIVE_IS_SPECIFIED');
				$link =  'index.php?option='. $option;				
			} else {
				$model = &$this->getModel('ruleset');			
				if ($model->deleteRuleset($cid, $ruleset_file)) {
					$msg = JText::_('COM_TABULIZER_SELECTED_RULESETS_DELETED_SUCCESSFULLY');
					$link =  'index.php?option='.$option.'&task=viewrulesetarchive&archive_filename='.$ruleset_file;
				} else {
					$msg = JText::_('COM_TABULIZER_RULESETS_DELETION_FAILED');
					$link =  'index.php?option='. $option;
				}
			}					
		} else {
			$msg = JText::_('COM_TABULIZER_NO_RULESETS_SELECTED_FOR_DELETION');
			$link =  'index.php?option='. $option;			
		}
		
		$this->setRedirect($link, $msg);						
	}	

	
	//=============================================================================================
	// RULE
	//=============================================================================================		
	
	function getRuleArgs(&$rule_id, &$ruleset_name, &$ruleset_file) {
		$rule_id = JRequest::getString( 'rule_id', '' );		
		$ruleset_name = JRequest::getString( 'ruleset_name', '' );
		$ruleset_file = JRequest::getString( 'archive_filename', '' );		

		if (empty($ruleset_file)) {
			$msg = JText::_('COM_TABULIZER_NO_RULESET_ARCHIVE_IS_SPECIFIED');
			$link =  'index.php?option='. $option;
			$this->setRedirect($link, $msg);
		} else if (empty($ruleset_name)) {
			$msg = JText::_('COM_TABULIZER_NO_RULESET_NAME_IS_SPECIFIED');
			$link =  'index.php?option='. $option;
			$this->setRedirect($link, $msg);
		} else if (!is_numeric($rule_id)) {
			$msg = JText::_('COM_TABULIZER_NO_RULE_ID_IS_SPECIFIED');
			$link =  'index.php?option='. $option;
			$this->setRedirect($link, $msg);
		} else {
			return true;
		}
		
		return false;
	}

	function viewRule() {
		jexit('viewRule: Not yet implemented!');
	
	}
	
	function newRule() {
		$option = JRequest::getCmd('option');
	
		$ruleset_name = JRequest::getString( 'ruleset_name', '' );
		$ruleset_file = JRequest::getString( 'archive_filename', '' );		

		if (empty($ruleset_file)) {
			$msg = JText::_('COM_TABULIZER_NO_RULESET_ARCHIVE_IS_SPECIFIED');
			$link =  'index.php?option='. $option;
			$this->setRedirect($link, $msg);
		} else if (empty($ruleset_name)) {
			$msg = JText::_('COM_TABULIZER_NO_RULESET_NAME_IS_SPECIFIED');
			$link =  'index.php?option='. $option;
			$this->setRedirect($link, $msg);
		} else {
			$model = &$this->getModel('ruleset');			
			$view = &$this->getView('rule','html');
			$ruleset = $model->loadRuleset($ruleset_name, $ruleset_file);
			if (empty($ruleset)) {
				$msg = JText::_('COM_TABULIZER_SPECIFIED_RULESET_IS_EMPTY_OR_NOT_FOUND');
				$link =  'index.php?option='. $option;
				$this->setRedirect($link, $msg);
			} else {			
				$view->setModel($model, true);
				$view->setLayout('form');
				$view->displayNew();					
			}			
		}						
	
	}
	
	function editRule() {
		$option = JRequest::getCmd('option');		
		
		if ($this->getRuleArgs($rule_id, $ruleset_name, $ruleset_file)) {						
			$model = &$this->getModel('rule');			
			$view = &$this->getView('rule','html');												
			$rule = $model->loadRule($rule_id, $ruleset_name, $ruleset_file);
			if (empty($rule)) {
				$msg = JText::_('COM_TABULIZER_SPECIFIED_RULE_IS_EMPTY_OR_NOT_FOUND');
				$link =  'index.php?option='. $option;
				$this->setRedirect($link, $msg);
			} else {			
				$view->setModel($model, true);
				$view->setLayout('form');
				$view->displayEdit();					
			}								
		} else {
			$msg = JText::_('COM_TABULIZER_INVALID_ARGS');				
			$redirect_link =  'index.php?option='. $option;			
			$this->setRedirect($redirect_link, $msg);
		}				
		
	}
	
	function saveRule() {
		$option = JRequest::getCmd('option');		
		
		if ($this->getRuleArgs($rule_id, $ruleset_name, $ruleset_file)) {
			$redirect_link = 'index.php?option='.$option.'&task=viewruleset&ruleset_name='.$ruleset_name.'&archive_filename='.$ruleset_file;
			
			$rule = array('element'=> JRequest::getVar('element', null), 
						  'range'=> JRequest::getVar('range', null, 'default', 'none', JREQUEST_ALLOWRAW),
						  'range_count'=> JRequest::getInt('range_count', null),
 						  'style'=> JRequest::getVar('style', null),
						  'autospan'=> JRequest::getVar('autospan', null),
						  'format'=> JRequest::getVar('format_data_type', null),
						  'calculation' => JRequest::getVar('calculation', null));			
						  
			// replacement
			# We give the use free access to html tags, include img that would be strips form JRequest::getVar function			
			$replace_from = $_POST['replace_from'];
			$replace_to = $_POST['replace_to'];
			$replace_cs = JRequest::getInt('replace_cs', 0);
			if (!empty($replace_from)) {
				$rule['replacement'] = $replace_cs . REPLACEMENT_SEPARATOR . $replace_from . REPLACEMENT_SEPARATOR . $replace_to;
			}		
						  				  																		
			if ($rule['format']) {
				$data_type_params = JRequest::getVar('format_data_type_params','');
				if (!empty($data_type_params)) {
					$rule['format'] = $rule['format'] . DATA_TYPE_SEPARATOR . $data_type_params;
				} else {
					unset($rule['format']);
				}				
			}			  
												
			$model = &$this->getModel('rule');
			if ($model->saveRule($rule, $rule_id, $ruleset_name, $ruleset_file)) {
				$msg = JText::_('COM_TABULIZER_RULE_SAVED_SUCCESSFULLY');
			} else {
				$msg = JText::_('COM_TABULIZER_COULD_NOT_SAVE_RULE');				
			}			
		} else {
			$msg = JText::_('COM_TABULIZER_INVALID_ARGS');				
			$redirect_link =  'index.php?option='. $option;			
		}				
		
		$this->setRedirect($redirect_link, $msg);
	}
	
	function deleteRule() {
		$option = JRequest::getCmd('option');				
		
		$cid	= JRequest::getVar( 'cid', array(0), 'request', 'array' );
		JArrayHelper::toInteger($cid);
	    if (count( $cid )) {
			$ruleset_name = JRequest::getString( 'ruleset_name', '' );
			$ruleset_file = JRequest::getString( 'archive_filename', '' );		
	
			if (empty($ruleset_file)) {
				$msg = JText::_('COM_TABULIZER_NO_RULESET_ARCHIVE_IS_SPECIFIED');
				$link =  'index.php?option='. $option;				
			} else if (empty($ruleset_name)) {
				$msg = JText::_('COM_TABULIZER_NO_RULESET_NAME_IS_SPECIFIED');
				$link =  'index.php?option='. $option;
			} else {
				$model = &$this->getModel('rule');			
				if ($model->deleteRule($cid, $ruleset_name, $ruleset_file)) {
					$msg = JText::_('COM_TABULIZER_SELECTED_RULES_DELETED_SUCCESSFULLY');
					$link =  'index.php?option='.$option.'&task=viewruleset&ruleset_name='.$ruleset_name.'&archive_filename='.$ruleset_file;
				} else {
					$msg = JText::_('COM_TABULIZER_RULES_DELETION_FAILED');
					$link =  'index.php?option='. $option;
				}
			}					
		} else {
			$msg = JText::_('COM_TABULIZER_NO_RULES_SELECTED_FOR_DELETION');
			$link =  'index.php?option='. $option;			
		}
		
		$this->setRedirect($link, $msg);						
	}	
	
	function isAllowed($task, &$user_msg) {		
		require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'assets'.DS.'classes'.DS.'dialog'.DS.'permissions.php');
		$perm = new TabulizerPermissions();
		
		$allowed = 0; // unless otherwise proven
							
		switch ($task) {			
			case 'newRulesetArchive':
			case 'editRulesetArchive':
			case 'saveRulesetArchive':
			case 'deleteRulesetArchive':
			case 'newRuleset':
			case 'editRuleset':
			case 'saveRuleset':
			case 'deleteRuleset':
			case 'newRule':
			case 'editRule':
			case 'saveRule':
			case 'deleteRule':
				$allowed = ($perm->isAllowed('ruleset-edit'))?1:0;
				$user_msg = JText::_('COM_TABULIZER_PERMISSION_REQUIRED_FOR_RULESET_EDIT');
				break;
									
			case 'importRulesetArchive':
				$allowed = ($perm->isAllowed('ruleset-import'))?1:0;
				$user_msg = JText::_('COM_TABULIZER_PERMISSION_REQUIRED_FOR_RULESET_IMPORT');				
				break;			

			case 'extract_excel_data':
			case 'upload_excel_file':			
				$allowed = ($perm->isAllowed('excel-import'))?1:0;
				$user_msg = JText::_('COM_TABULIZER_PERMISSION_REQUIRED_FOR_EXCEL_IMPORT');				
				break;			
				
			default:
				$allowed = ($perm->isAllowed('ruleset-use'))?1:0;				
				$user_msg = JText::_('COM_TABULIZER_PERMISSION_REQUIRED_FOR_RULESET_USE');	
				break;
		}
		
		return $allowed;
	}
	
	function checkSessionTokenValidity($task) {
		$option = JRequest::getCmd('option');						
		$link = 'index.php?option='. $option;		
		$msg = JText::_('COM_TABULIZER_SESSION_TOKEN_INVALID');
		$valid = false;

		switch ($task) {							
			case 'saveRulesetArchive':
			case 'saveRuleset':
			case 'saveRule':
				$valid = JRequest::checkToken();	
				if (!$valid) {
					$this->setRedirect($link, $msg);
				}
				break;
											
			case 'deleteRulesetArchive':
			case 'deleteRuleset':
			case 'deleteRule':
				// token in URL
				$valid = JRequest::checkToken( 'get' );		
				// token in form (hidden field)
				if (!$valid) $valid = JRequest::checkToken();
				if (!$valid) {
					$this->setRedirect($link, $msg);
				}								
				break;				
							
			case 'importRulesetArchive':
				$importFileData = JRequest::getVar( 'import_file', 0);
				$displayForm = ($importFileData)?false:true;
				if ($displayForm) $valid = true;		
				else $valid = JRequest::checkToken();
				if (!$valid) {
					$this->setRedirect($link, $msg);
				}			
				break;
				
			case 'extract_table_data':
			case 'extract_excel_data':
			case 'upload_excel_file':			
				$valid = JRequest::checkToken();	
				if (!$valid) {
					$output = json_encode(array("error_msg" => $msg));
					jexit($output);
				}				
				break;
				
			case 'convert':
				$valid = JRequest::checkToken();	
				if (!$valid) {
					$html = ERROR_CODE_PREFIX;				
					$html .= '<error>'.$msg.'</error>';		
					jexit($msg);
				}
				break;					
				
			default:
				$valid = true;				
				break;
		}
		
		return $valid;		
	}
	
	function printWarning($msg, $use_html = true) {
		if ($use_html) {
			TabulizerUserMessage::printError($msg);
		} else {
			echo $msg;		
		}
	}


}


?>