<?php
defined( '_JEXEC' ) or die( 'Restricted access' );

class ExcelUploader {	

	function file_upload_error_message($error_code) {
		$error_msg = '';
		switch ($error_code) {
			case UPLOAD_ERR_INI_SIZE:
				$error_msg = JText::_('COM_TABULIZER_UPLOAD_ERR_INI_SIZE');
			case UPLOAD_ERR_FORM_SIZE:
				$error_msg = JText::_('COM_TABULIZER_UPLOAD_ERR_FORM_SIZE');
			case UPLOAD_ERR_PARTIAL:
				$error_msg = JText::_('COM_TABULIZER_UPLOAD_ERR_PARTIAL');
			case UPLOAD_ERR_NO_FILE:
				$error_msg = JText::_('COM_TABULIZER_UPLOAD_ERR_NO_FILE');
			case UPLOAD_ERR_NO_TMP_DIR:
				$error_msg = JText::_('COM_TABULIZER_Missing a temporary folder');
			case UPLOAD_ERR_CANT_WRITE:
				$error_msg = JText::_('COM_TABULIZER_UPLOAD_ERR_CANT_WRITE');
			case UPLOAD_ERR_EXTENSION:
				$error_msg = JText::_('COM_TABULIZER_UPLOAD_ERR_EXTENSION');
			default:
				$error_msg = 'Unknown upload error';
		}
		return $error_msg;
	} 
	
	function verifyUploadedFile(&$sheet_filename, &$error_msg) {
		$uploaded_fieldname = 'sheet_file';
		
		if ($_FILES[$uploaded_fieldname]["error"] > 0) {
			$error_msg = sprintf(JText::_('COM_TABULIZER_SHEET_UPLOAD_FAILED'),$this->file_upload_error_message($_FILES[$uploaded_fieldname]["error"]));
			return false;
		} else {
			$uploaded_filename = $_FILES[$uploaded_fieldname]['name'];
			$uploaded_file = $_FILES[$uploaded_fieldname]['tmp_name'];
			$uploaded_size = $_FILES[$uploaded_fieldname]["size"];
			$uploaded_type = strtolower($_FILES[$uploaded_fieldname]["type"]);							
			
			# sanity checks
			// 1. File size
			if ($uploaded_size > MAX_UPLOAD_SHEET_FILE_SIZE) {
				$error_msg = sprintf(JText::_('COM_TABULIZER_SHEET_UPLOAD_INVALID_FILE_SIZE'),MAX_UPLOAD_SHEET_FILE_SIZE);
				return false;
			}
			
			// 2. File type
			$valid_mime_types = array('application/vnd.ms-excel' /* official */, 'application/msexcel', 'application/x-msexcel', 'application/x-ms-excel', 'application/x-excel', 'application/x-dos_ms_excel', 'application/xls', 'application/octet-stream');
			
			
			if (!in_array($uploaded_type, $valid_mime_types)) { 
				$error_msg = sprintf(JText::_('COM_TABULIZER_SHEET_UPLOAD_INVALID_FILE_TYPE'), $uploaded_type);
				return false;
			} 
			
			// 3. File extension
			$path_parts = pathinfo($uploaded_filename);
			$filename_ext = strtolower($path_parts['extension']);
			if ($filename_ext != 'xls') {
				$error_msg = sprintf(JText::_('COM_TABULIZER_SHEET_UPLOAD_INVALID_FILE_EXT'), $filename_ext);
				return false;				
			}
			
			# Copy file to temp dir
			$import_hash = time() . mt_rand();
			$sheet_filename = 'sheet' . $import_hash . '.utemp.xls';			
			$temp_filename_path = JPATH_SITE . DS . SHEET_UPLOAD_DIR . $sheet_filename;			
			if(!move_uploaded_file($uploaded_file, $temp_filename_path)) { 
				$error_msg = sprintf(JText::_('COM_TABULIZER_SHEET_UPLOAD_MOVE_FAILED'),$temp_filename_path);
				return false;
			}								
		}
		
		return true;
	}

	function process() {
		$error_msg = null;
		$sheet_filename = null;
		
		if ($this->verifyUploadedFile($sheet_filename, $error_msg)) {
			$this->outputData($sheet_filename, $error_msg);
		} else {
			$this->outputData(null, $error_msg);
		}		
	}

	
	function outputData($filename, $error_msg) {
		if (!empty($error_msg)) {
			$output = json_encode(array("error_msg" => $error_msg));
		} else {
			$output = json_encode(array("filename" => $filename));
		}
		
		echo '<div id="upload_file_return">'.$output.'</div>';
	}
			
}

$form = new ExcelUploader();
$form->process();

?>