<?php
defined( '_JEXEC' ) or die( 'Restricted access' );

// increase memory and execution time limits
increaseProcessingLimits();

class ExcelExtraction {
	
	var $sheet_id = null;
	var $sheet_selection_from = null;
	var $sheet_selection_to = null;
	var $sheet_filename = null;
	var $sheet_preferences = null;	
	
	function getInput(&$error_msg) {					

		// get and verify uploaded file
		$file_is_valid = false;
		$this->sheet_filename = JRequest::getString('sheet_filename','');
		if (preg_match('/^sheet(\d+).utemp.xls$/',$this->sheet_filename,$matches)) {
			$this->sheet_filename = JPATH_SITE . DS . SHEET_UPLOAD_DIR . $this->sheet_filename;
			if (file_exists($this->sheet_filename)) {		
				$size = filesize($this->sheet_filename);				
				if ($size > MAX_UPLOAD_SHEET_FILE_SIZE) {
					$error_msg = sprintf(JText::_('COM_TABULIZER_SHEET_UPLOAD_INVALID_FILE_SIZE'),MAX_UPLOAD_SHEET_FILE_SIZE);
					return false;
				}
				$file_is_valid = true;
			}
		}
		if (!$file_is_valid) {
			$error_msg = sprintf(JText::_('COM_TABULIZER_SHEET_UPLOAD_INVALID_FILE_NAME'),$this->sheet_filename);
			return false;
		}											
	
		// get selected sheet id
		$sheet_id = trim(JRequest::getInt('sheet_id', '0'));
		if (preg_match('/(\d+)/',$sheet_id, $matches)) {
			$sheet_id = intval($sheet_id);
			if ($sheet_id > 0) $this->sheet_id = $sheet_id - 1; // we start counting from 0 ...
			else $this->sheet_id = 0;
		} else {
			$error_str = JText::_('COM_TABULIZER_INVALID_SHEET_ID');
			return false;
		}
	
		// get selected sheet area coordinates
		$selection_coords = JRequest::getString('sheet_selection','');						
		list($top_coords, $bottom_coords) = explode(':',$selection_coords);		
		$this->sheet_selection_from = $this->getCellCoordinates($top_coords);
		$this->sheet_selection_to = $this->getCellCoordinates($bottom_coords);
		if (empty($this->sheet_selection_from) || empty($this->sheet_selection_to)) {
			$error_str = JText::_('COM_TABULIZER_INVALID_SHEET_AREA_SELECTION');
			return false;
		} 
		$row_from = $this->sheet_selection_from['row'];
		$row_to = $this->sheet_selection_to['row'];
		$col_from = $this->sheet_selection_from['col'];
		$col_to = $this->sheet_selection_to['col'];
		if (($row_from > $row_to)||($col_from > $col_to)) {
			$error_str = JText::_('COM_TABULIZER_INVALID_SHEET_AREA_SELECTION');
			return false;
		}
		
		// get process preferences
		$this->sheet_preferences = array('read_font' => false, 'read_color' => false, 'remove_empty' => false, 'read_hyperlinks' => false, 'extended_info' => false);
		foreach ($this->sheet_preferences as $key => &$value) {
			if (JRequest::getInt('sheet_'.$key,0)) {
				$this->sheet_preferences[$key] = true;
			}
		}
		if (($this->sheet_preferences['read_font']) || ($this->sheet_preferences['read_color'])) 
			$this->sheet_preferences['extended_info'] = true;
				
		// everything is OK
		return true;
	}
	
	function getCellCoordinates($str) {
		$alpha_value = array('A'=>1,'B'=>2,'C'=>3,'D'=>4,'E'=>5,'F'=>6,'G'=>7,'H'=>8,'I'=>9,'J'=>10,'K'=>11,'L'=>12,'M'=>13,'N'=>14,'O'=>15,'P'=>16,'Q'=>17,'R'=>18,'S'=>19,'T'=>20,'U'=>21,'V'=>22,'W'=>23,'X'=>24,'Y'=>25,'Z'=>26);
		
		if (empty($str)) return null; else $str = strtoupper($str);
		if (preg_match('/([A-Z]+)(\d+)/',$str,$matches)) {			
			$col_alpha = $matches[1];
			$row = $matches[2];			
		} else if (preg_match('/(\d+)([A-Z]+)/',$str,$matches)) {
			$row = $matches[1];
			$col_alpha = $matches[2];		
		} else {
			return null;
		}	
			
		$col = 0;
		$len = strlen($col_alpha);
		for ($i = 0; $i < $len; $i++) {
			$char = $col_alpha{$i};
			$col += $alpha_value[$char] * pow(26,$len-$i-1);
		}						
		return array('row'=>$row, 'col'=>$col);
		
	}
	
	function process() {
		$error_msg = null;
		
		$this->getInput($error_msg);												
		if (!$error_msg) {
			$this->extractTableData($table_text, $column_separator, $error_msg);
			$this->outputData($table_text, $column_separator, $error_msg);
		} else {
			$this->outputData(null, null, $error_msg);
		}
	}
	
	function extractTableData(&$table_text, &$column_separator, &$error_msg) {		
		
		// open file and read data
		require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'assets'.DS.'classes'.DS.'dialog'.DS.'excel_reader.php');		
		$data = new Spreadsheet_Excel_Reader($this->sheet_filename, $this->sheet_preferences['extended_info'], 'UTF-8');
		if (empty($data)) {
			$error_msg = JText::_('COM_TABULIZER_SHEET_UPLOAD_CANNOT_READ_FILE_DATA');
			return false;		
		}
		
		// get selection area
		$row_from = $this->sheet_selection_from['row'];
		$row_to = $this->sheet_selection_to['row'];
		$col_from = $this->sheet_selection_from['col'];
		$col_to = $this->sheet_selection_to['col'];
		
		$sheet = $this->sheet_id;
		
		// construct table
		$table = array();
		$cell_values = array();		
		for ($row=$row_from;$row<=$row_to;$row++) {
			for ($col=$col_from;$col<=$col_to;$col++) {
				$value = $data->val($row, $col, $sheet);
				$row_id = $row - $row_from + 1;
				$column_id = $col - $col_from + 1;
				if (!isset($table[$row_id])) $table[$row_id] = array();
				$table[$row_id][$column_id] = $value;
				if (!is_null($value) && ($value != '')) {					
					$cell_info = array(
						'hyperlink' => $data->hyperlink($row,$col,$sheet),
						'style' => ''
					);
					if ($this->sheet_preferences['extended_info']) {
						if ($this->sheet_preferences['read_font']) {
							$font_style = array();
							if ($data->bold($row,$col,$sheet)) $font_style['font-weight'] = 'bold';
							if ($data->italic($row,$col,$sheet)) $font_style['font-style'] = 'italic';
							if ($data->underline($row,$col,$sheet)) $font_style['text-decoration'] = 'underline';
							if ($data->height($row,$col,$sheet)) {
								$font_size = intval($data->height($row,$col,$sheet));
								$font_style['font-size'] = $font_size . 'px';
							}
							if (!empty($font_style)) {
								foreach ($font_style as $attribute_name=>$attribute_value) {
									$cell_info['style'] .= $attribute_name . ':' . $attribute_value . ';';
								}
							}								
						} 
						if ($this->sheet_preferences['read_color']) {
							$color_style = array();
							$color_value = $data->color($row,$col,$sheet);
							if ($color_value) {
								$color_style['color'] = $data->colors[$color_value];
							}
							$color_value = $data->bgColor($row,$col,$sheet);
							if ($color_value) {
								$color_style['background-color'] = $data->colors[$color_value];
								$color_style['display'] = 'block'; // span covers the whole table cell
							}
							if (!empty($color_style)) {
								foreach ($color_style as $attribute_name=>$attribute_value) {
									$cell_info['style'] .= $attribute_name . ':' . $attribute_value . ';';
								}
							}		
						}											
					}			
					
					$cell_value = $value;
					if (!empty($cell_info['style'])) {
						$cell_value = "<span style='{$cell_info['style']}'>{$cell_value}</span>";
					}					
					if ($this->sheet_preferences['read_hyperlinks']) {
						if (!empty($cell_info['hyperlink'])) $cell_value = "<a href='{$cell_info['hyperlink']}'>{$cell_value}</a>"; 
					}										
					$cell_values[] = $cell_value;
					$table[$row_id][$column_id] = $cell_value;
				}	
			}
		}
		
		// when we are done with reading the sheet file, remove it
		@unlink($this->sheet_filename);
		$this->sheet_filename = null;
		
		// remove empty border rows/columns
		if ($this->sheet_preferences['remove_empty']) {
			$num_of_rows = count($table);
			$num_of_columns = count($table[1]);
			$empty_column = array();
			for ($i=1;$i<=$num_of_columns;$i++) { $empty_column[$i] = true; }
			foreach ($table as $row_id => $cells) {
				$empty_row = true;
				foreach ($cells as $cell_id => $value) {
					if ($value != '') { $empty_row = false; $empty_column[$cell_id] = false; }
				}
				if ($empty_row) {
					unset($table[$row_id]);
				}
			}
			for ($i=1;$i<=$num_of_columns;$i++) { 
				if ($empty_column[$i]) {
					for ($j=1;$j<=$num_of_rows;$j++) {
						if (isset($table[$j])) unset($table[$j][$i]);
					}
				}
			}		
		}
		
		// find column separator
		$column_separator_found = false;		
		if (empty($cell_values)) {
			$error_msg = JText::_('COM_TABULIZER_INVALID_EXCEL_SELECTION');
			return;
		} else {
			$separators = array('","' => SEPARATOR_COMMA,'";"' => SEPARATOR_SEMICOLON, '"^"' => SEPARATOR_CARET, '"*"' => SEPARATOR_ASTERISK, '" "'=>SEPARATOR_SPACE, '"\t"' => SEPARATOR_TAB);
			foreach ($separators as $sep => $column_separator) {
				$valid = true;
				foreach ($cell_values as $value) {
					if (empty($value)) continue;
					if (strpos($value,$sep) !== false) { $valid = false; break; }
				}
				if ($valid) {
					$column_separator_found = true;
					break;
				}
			}			
		}		
		if (empty($column_separator_found)) {
			$error_msg = JText::_('COM_TABULIZER_INVALID_EXCEL_SELECTION');
			return;
		}
		
		// construct table text
		foreach ($table as $row_id => $cells) {
			$current_count = count($cells);
			if (empty($column_count)) $column_count = $current_count;
			else if ($column_count != $current_count) {
				$error_msg = JText::_('COM_TABULIZER_INVALID_EXCEL_SELECTION');
				return;
			}
			$table_text .= '"'. implode($sep,$cells) . '"' . "\n";
		}	

	}
	
	function outputData($table_text, $column_separator, $error_msg) {
		if (!empty($error_msg)) {
			$output = json_encode(array("error_msg" => $error_msg));
		} else {
			$output = json_encode(array("table_text" => $table_text, 'column_separator' => $column_separator));
		}
		
		jexit($output);
	}
			
}

$form = new ExcelExtraction();
$form->process();

?>
