﻿<?php
defined( '_JEXEC' ) or die( 'Restricted access' );

$clb_name = addslashes( $_GET['clb_name'] );
$use_comments = intval($_GET['use_comments']);
if (!empty($_GET['caret_position'])) {
	$retabulizer = true;
	$caret_position = $_GET['caret_position'];
} else {
	$retabulizer = false;	
}

function checkPermission($action = 'excel-import') {
	# for security purposes, allow the user to use the "load from excel file data" only when he is logged in the admin area
	require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'assets'.DS.'classes'.DS.'dialog'.DS.'permissions.php');
	$perm = new TabulizerPermissions();
	$allow_excel_loading = ($perm->isAllowed($action))?1:0;
	
	return $allow_excel_loading;
}

$allow_excel_loading = checkPermission();

// load rulesets
function getRulsets() {

	# init
	$archives = array();
	$archive_options = array();
	$archive_descriptions = array();
	$archive_to_rulesets = array();			
	
	$rulesets = array();
	$ruleset_options = array();
	$ruleset_descriptions = array();

	$init_description = null;	

	# load all xml files in rules folder
	$dir = JPATH_SITE . DS. RULES_XML_DIR;
	$xmlfiles = array();
	if (is_dir($dir)) {
		if ($dh = opendir($dir)) {
			while (($file = readdir($dh)) !== false) {
				if (is_file($dir . $file)) {
					if (preg_match('/'.XML_FILE_EXT.'$/',$file)) {
						$xmlfiles[] = $dir . $file;
					}
				}
			}	
			closedir($dh);
		}			
	}
	
	# traverse files			
	if (!empty($xmlfiles)) {
		foreach ($xmlfiles as $xmlfile) {
			$contents = file_get_contents($xmlfile);
			$p = xml_parser_create();
			xml_parse_into_struct($p, $contents, $vals, $index);
			xml_parser_free($p);
									
			foreach ($vals as $node) {
				switch ($node['tag']) {
					case 'RULES':
						if ($node['type'] == 'open') {					
							$archive_name = $node['attributes']['NAME'];
							$archive_title = $node['attributes']['TITLE'];
							if (empty($node['attributes']['DESCRIPTION'])) $description = sprintf(JText::_('COM_TABULIZER_NO_ARCHIVE_DESCRIPTION'),$archive_title); else $description = $node['attributes']['DESCRIPTION'];
							$archives[$archive_name] = array('title' => $archive_title, 'description' => $description); 
						} else if ($node['type'] == 'complete') {								
							$archive_name = $node['attributes']['NAME'];
							$archive_title = $node['attributes']['TITLE'];
							if (empty($node['attributes']['DESCRIPTION'])) $description = sprintf(JText::_('COM_TABULIZER_NO_ARCHIVE_DESCRIPTION'),$archive_title); else $description = $node['attributes']['DESCRIPTION'];
							$archives[$archive_name] = array('title' => $archive_title, 'description' => $description, 'rulesets' => $rulesets, 'preselected' => false); 
						} else if ($node['type'] == 'close') {							
							$preselected = false;
							foreach ($rulesets as $ruleset) {
								if ($ruleset['preselected']) $preselected = true;
								break;
								
							}
							$archives[$archive_name]['rulesets'] = $rulesets;
							$archives[$archive_name]['preselected'] = $preselected;
							$rulesets = array();							
						}
						break;
					case 'RULESET':
						if (($node['type'] == 'open') || ($node['type'] == 'complete')) {					
							$name = $node['attributes']['NAME'];
							$title = $node['attributes']['TITLE'];
							if (empty($node['attributes']['DESCRIPTION'])) $description = sprintf(JText::_('COM_TABULIZER_NO_RULESET_DESCRIPTION'),$title); else $description = $node['attributes']['DESCRIPTION'];
							if (isset($node['attributes']['PRESELECTED'])) $preselected = true; else $preselected = false; 
							$rulesets[$name] = array('title' => $title, 'description' => $description, 'preselected' => $preselected); 								
						}
						break;
				}
			}
			
		}
	}
	
	if (!empty($archives)) {
		$archive_options[] = '<option value="0">'.htmlspecialchars(JText::_('COM_TABULIZER_ALL'),ENT_COMPAT,'UTF-8').'</option>';
		foreach ($archives as $archive_name => $archive) {
			$title = empty($archive['title'])?$archive_name:$archive['title'];
			if ($archive['preselected']) {				
				$archive_options[] = '<option value="'.htmlspecialchars($archive_name,ENT_COMPAT,'UTF-8').'" selected="selected">'.htmlspecialchars($title,ENT_COMPAT,'UTF-8').'</option>';
				$init_description = htmlspecialchars($archive['description'],ENT_COMPAT,'UTF-8');
			} else {
				$archive_options[] = '<option value="'.htmlspecialchars($archive_name,ENT_COMPAT,'UTF-8').'">'.htmlspecialchars($title,ENT_COMPAT,'UTF-8').'</option>';
			}
			$archive_descriptions[] = '"'.$archive_name.'": "'.htmlspecialchars($archive['description'],ENT_COMPAT,'UTF-8'). '"';
			$rulesets = $archive['rulesets'];
			if (!empty($rulesets)) {								
				foreach ($rulesets as $name => $ruleset) {
					$title = empty($ruleset['title'])?$name:$ruleset['title'];
					if ($ruleset['preselected']) {
						$ruleset_options[] = '<option value="'.htmlspecialchars($name,ENT_COMPAT,'UTF-8').'" selected="selected">'.htmlspecialchars($title,ENT_COMPAT,'UTF-8').'</option>';
						$init_description = htmlspecialchars($ruleset['description'],ENT_COMPAT,'UTF-8');
					} else {
						$ruleset_options[] = '<option value="'.htmlspecialchars($name,ENT_COMPAT,'UTF-8').'">'.htmlspecialchars($title,ENT_COMPAT,'UTF-8').'</option>';		
					}				
					$ruleset_descriptions[] = '"'.$name.'": "'.htmlspecialchars($ruleset['description'],ENT_COMPAT,'UTF-8'). '"';
					if (!isset($archive_to_rulesets[$archive_name])) $archive_to_rulesets[$archive_name] = array('"'.$name.'": "'.htmlspecialchars($title,ENT_COMPAT,'UTF-8'). '"');
					else $archive_to_rulesets[$archive_name][] = '"'.$name.'": "'.htmlspecialchars($title,ENT_COMPAT,'UTF-8'). '"';
				}				
			}									
		}
						
	}
	
	$data = array();
	if (!empty($archive_options)) {
		$data['archive_options'] = '<select name="archive_name" id="archive_name" onchange="TabulizerUpdateRulesetArchive(this)">'. implode('', $archive_options). '</select>';
	} else $data['archive_options'] = JText::_('COM_TABULIZER_NONE') . '<input type="hidden" name="archive_name" value="none">';
	if (!empty($archive_descriptions)) {
		$data['archive_descriptions'] = implode(',', $archive_descriptions);
	} else $data['archive_descriptions'] = '';	
	if (!empty($ruleset_options)) {
		$data['ruleset_options'] = '<select name="ruleset_name" id="ruleset_name" onchange="TabulizerUpdateRuleset(this)">'. implode('', $ruleset_options). '</select>';
	} else $data['ruleset_options'] = JText::_('COM_TABULIZER_NONE') . '<input type="hidden" name="ruleset_name" value="none">';
	if (!empty($ruleset_descriptions)) {
		$data['ruleset_descriptions'] = implode(',', $ruleset_descriptions);
	} else $data['ruleset_descriptions'] = '';
	if (!empty($archive_to_rulesets)) {
		$data['archive_to_rulesets'] = '';
		foreach ($archive_to_rulesets as $archive_name => $rulesets) {
			$data['archive_to_rulesets'] .= '		archive_to_rulesets["'.$archive_name.'"] = {'.implode(',',$rulesets).'};' . "\n";
		}
	} else $data['archive_to_rulesets'] = '';
	
	$data['init_description'] = $init_description;
	
	return $data;
	
}				

$data = getRulsets();
$archive_options = $data['archive_options'];
$archive_descriptions = $data['archive_descriptions'];
$archive_to_rulesets = $data['archive_to_rulesets'];
$ruleset_options = $data['ruleset_options'];
$ruleset_descriptions = $data['ruleset_descriptions'];
$init_description = $data['init_description'];

$page_title = JText::_('COM_TABULIZER_TITLE');
$assets_path = JURI::root(true) . '/administrator/components/com_tabulizer/assets/classes/dialog/';
$css_url = $assets_path . 'dialog.css';
$js_url = $assets_path . 'jquery-1.6.4.min.js';

$js_code = '';
	
if ($retabulizer) {
$js_code .= '	jQuery(document).ready(function() {
	
		var tabulizerForm = jQuery("#tabulizer_form");
			
		var editorContent = document.getElementById("editor_content");		
		editorContent.value = window.opener.retabulizerGetEditorContent();
				
		var dataString = tabulizerForm.serialize();
		var url = "'.JURI::base().'index.php?option=com_tabulizer&task=extract_table_data&tmpl=component' . '";
		var dataType = "json";
		
		var ajax_infobox = document.getElementById("ajax_infobox");		
		ajax_infobox.innerHTML = "<span class=\'ajax_loading\'>'.JText::_('COM_TABULIZER_AJAX_LOADING').'</span>";
				
		jQuery.post(
			url,
			dataString,
			function(response,status,xhr) {		
				ajax_infobox.innerHTML = "";																						
				if (status == "success") {
					// check for error codes
					if (response.error_msg) {
						alert(response.error_msg);
					} else if (response.table_text) {
						var tableText = document.getElementById("tabulizer_text");			
						tableText.value = response.table_text;
						var replace_from = document.getElementById("editor_replace_from");	
						replace_from.value = response.range_from;
						var replace_to = document.getElementById("editor_replace_to");							
						replace_to.value = response.range_to;	
						var column_separator = document.getElementById("column_separator");						
						for (var i=0; i<column_separator.options.length; i++){
							if (column_separator.options[i].value == response.column_separator){
								column_separator.options[i].selected=true;
								break;
							}
						}
					} else {
						alert(response);
					}
				} else {
					alert("'.JText::_('COM_TABULIZER_NO_TABLE_EXTRACTION_UTILITY').'");
				}
			},
			dataType);													

	});
		
	function TabulizerInsertClick() {	 
  	  var result = document.getElementById("tabulizer_html").value;	
	  var replace_from = document.getElementById("editor_replace_from").value; 
	  var replace_to = document.getElementById("editor_replace_to").value;	
	  
	  window.opener.retabulizerClickCallback( "'.$clb_name.'", result, replace_from, replace_to );
	  window.close();
	}
';
	} else {

$js_code .= '					
	function TabulizerInsertClick() {	 
  	  var result = document.getElementById("tabulizer_html").value;	
	  
	  window.opener.tabulizerClickCallback( "'.$clb_name.'", result );
	  window.close();
	}
';		
				
	}
	
$js_code .= '			
	function TabulizerCancelClick() {
	  window.close();
	}				
	
	function TabulizerConvertClick() {
		var tabulizerForm = jQuery("#tabulizer_form");
		var tableText = jQuery("#tabulizer_text");	
		var tableHTML = jQuery("#tabulizer_html");
		
		if (tableText.value == "") {
			alert("'.JText::_("COM_TABULIZER_NO_INPUT_TEXT").'");
			return false;
		}		
				
		var dataString = tabulizerForm.serialize();
		var url = "'.JURI::base() . 'index.php?option=com_tabulizer&task=convert&tmpl=component'. '";
		var dataType = "text";
				
		jQuery.post(
			url,
			dataString,
			function(response,status,xhr) {							
				var tableText = document.getElementById("tabulizer_text");	
				var tableHTML = document.getElementById("tabulizer_html");
				
				if (status == "success") {
					// check for error codes
					var erRegExp = /^'.ERROR_CODE_PREFIX.'/;
					var ePosition = response.search(erRegExp);
					if (ePosition == 0) {
						var error_msg = "'.JText::_('COM_TABULIZER_CONVERSION_ERRORS_FOUND').'";						
						var regex_error_msg = /<error\b[^>]*>(?:(?=([^<]+))\1|<(?!error\b[^>]*>))*?<\/error>/g;
						var error_msgs = response.match(regex_error_msg);
						var ecount = 1;											
						for (var error_i=0;error_i<error_msgs.length;error_i++) {
							error_msgs[error_i] = error_msgs[error_i].replace(/<error>/,"");
							error_msgs[error_i] = error_msgs[error_i].replace(/<\/error>/,"");
							error_msg = error_msg + "\n" + ecount + ". " + error_msgs[error_i]; 
							ecount++;
						}																		
						alert(error_msg);
						tableHTML.value = "";
					} else {										
						tableHTML.value = response;				
						tableHTML.select();
					}
				} else {
					alert("'.JText::_('COM_TABULIZER_NO_CONVERSION_FORM').'");
				}
			},
			dataType);								
		
		return false;
	}	
	
	function TabulizerToggleExcelForm(){
		var div1 = document.getElementById("excel_upload_div");
		var label1 = document.getElementById("display_excel_label");
				
		if (div1.style.display == "none") {
			div1.style.display = "block";
			label1.innerHTML = "'.JText::_('COM_TABULIZER_LOAD_EXCEL_HIDE_BTN').'";
		} else {
			div1.style.display = "none";
			label1.innerHTML = "'.JText::_('COM_TABULIZER_LOAD_EXCEL_SHOW_BTN').'";			
		}
	}
	
	function TabulizerHideExcelForm(){
		var div1 = document.getElementById("excel_upload_div");
		var label1 = document.getElementById("display_excel_label");
				
		if (div1.style.display != "none") {
			div1.style.display = "none";
			label1.innerHTML = "'.JText::_('COM_TABULIZER_LOAD_EXCEL_SHOW_BTN').'";			
		}
	}		
	
';

if ($allow_excel_loading) {	
$js_code .= '		
	
	function TabulizerImportExcel() {
	
		var importForm = jQuery("#excel_form");
							
		var dataString = importForm.serialize();
		var url = "'.JURI::base().'index.php?option=com_tabulizer&task=extract_excel_data&tmpl=component' . '";
		var dataType = "json";
		
		var ajax_infobox = document.getElementById("ajax_infobox");		
		ajax_infobox.innerHTML = "<span class=\'ajax_loading\'>'.JText::_('COM_TABULIZER_AJAX_EXCEL_EXTRACTING').'</span>";
				
		jQuery.post(
			url,
			dataString,
			function(response,status,xhr) {																	
				ajax_infobox.innerHTML = "";			
				TabulizerHideExcelForm();
				if (status == "success") {
					// check for error codes
					if (response.error_msg) {
						alert(response.error_msg);
					} else {
						var tableText = document.getElementById("tabulizer_text");			
						tableText.value = response.table_text;						
						var column_separator = document.getElementById("column_separator");						
						for (var i=0; i<column_separator.options.length; i++){
							if (column_separator.options[i].value == response.column_separator){
								column_separator.options[i].selected=true;
								break;
							}
						}
					}
				} else {
					alert("'.JText::_('COM_TABULIZER_NO_TABLE_EXTRACTION_UTILITY').'");
				}
			},
			dataType);							
															
	}			
	
	function TabulizerUploadDone() {						
		var ret = null;
		var divs = frames["upload_target"].document.getElementsByTagName("div");
		if (divs) {
			for (var i=0;i<divs.length;i++) {
				if (divs[i].id == "upload_file_return") {
					ret = divs[i].innerHTML;
				}
			}
		}
		
		var ajax_infobox = document.getElementById("ajax_infobox");		
		ajax_infobox.innerHTML = "";
		
		if (ret) {
			var data = eval("("+ret+")");		
			if(data.filename) { 			
				document.getElementById("sheet_filename").value = data.filename;
				TabulizerImportExcel();			
			}
			else { 			
				alert(data.error_msg);
			}	
		} else {
			alert("Unknown communication error: client side or server side");
		}
	}
	
	function TabulizerUploadExcel() {		
		var uploadForm = jQuery("#upload_form");		
		jQuery("#upload_target").load(function (){    
			TabulizerUploadDone();
		});
		
		var valid = true;
		var f_value, f_regex, f_regex_b, error_msg = "";
		
		var ajax_infobox = document.getElementById("ajax_infobox");		
		ajax_infobox.innerHTML = "<span class=\'ajax_loading\'>'.JText::_('COM_TABULIZER_AJAX_EXCEL_UPLOADING').'</span>";
		
		f_value = document.getElementById("f_sheet_id").value;				
		f_value = f_value.replace(/\s/g, "");
		f_regex = new RegExp("^(\\\\d){1,3}$","");
		if (!f_regex.test(f_value)) { error_msg = "'.JText::_('COM_TABULIZER_INVALID_SHEET_ID').'"; valid = false;}
		else { document.getElementById("sheet_id").value = f_value; }
				
		f_value = document.getElementById("f_sheet_selection").value;
		f_value = f_value.replace(/\s/g, "");		
		f_regex = new RegExp("^([a-zA-Z]{1,3})(\\\\d+):([a-zA-Z]{1,3})(\\\\d+)$","");
		f_regex_b = new RegExp("^(\\\\d+)([a-zA-Z]{1,3}):(\\\\d+)([a-zA-Z]{1,3})$","");
		if ((!f_regex.test(f_value))&&(!f_regex_b.test(f_value))) { error_msg = "'.JText::_('COM_TABULIZER_INVALID_SHEET_AREA_SELECTION').'"; valid = false;}
		else { document.getElementById("sheet_selection").value = f_value; }

		f_value = document.getElementById("sheet_file").value;
		f_regex = new RegExp("^(.+)xls$","i");
		if (!f_regex.test(f_value)) { error_msg = "'.JText::_('COM_TABULIZER_INVALID_SHEET_FILENAME').'"; valid = false;}				
		
		if (document.getElementById("f_read_hyperlinks").checked) document.getElementById("sheet_read_hyperlinks").value = "1";
		if (document.getElementById("f_read_font").checked) document.getElementById("sheet_read_font").value = "1";
		if (document.getElementById("f_read_color").checked) document.getElementById("sheet_read_color").value = "1";
		if (document.getElementById("f_remove_empty").checked) document.getElementById("sheet_remove_empty").value = "1";
		
		if (valid) {
			uploadForm.submit();
		} else {
			alert(error_msg);
			ajax_infobox.innerHTML = "";
		} 
	}	
';
	}		
	
$js_code .= '				
	function TabulizerUpdateRuleset(ruleset_selection) {
		var ruleset_descriptions = { '.$ruleset_descriptions.' };
		var ruleset_name = ruleset_selection.value;
		jQuery("div.ruleset_description").html(ruleset_descriptions[ruleset_name]);
	}
	
	function TabulizerUpdateRulesetArchive(ruleset_archive_selection) {
		var archive_to_rulesets = new Array();
		'.$archive_to_rulesets.'
		var archive_name = ruleset_archive_selection.value;
		var ruleset_select = document.getElementById("ruleset_name");
		var rulesets, ruleset_count = 0;
				
		if (archive_name) {
			rulesets = archive_to_rulesets[archive_name];
			if (rulesets) {
				jQuery("option", ruleset_select).remove();
				jQuery.each(rulesets, function(val, text) {
					ruleset_select.options[ruleset_select.options.length] = new Option(text, val);
					ruleset_count++;
				});
				if (ruleset_count == 0) {		
					ruleset_select.options[ruleset_select.options.length] = new Option("'.JText::_('COM_TABULIZER_NONE').'", 0);
				}
			} else {
				// show all rulesets
				jQuery("option", ruleset_select).remove();			
				for(archive_name in archive_to_rulesets) {			
					rulesets = archive_to_rulesets[archive_name];					
					if (rulesets) {
						jQuery.each(rulesets, function(val, text) {
							ruleset_select.options[ruleset_select.options.length] = new Option(text, val);
						});				
						ruleset_count++;
					}					
				}
				if (ruleset_count == 0) {
					ruleset_select.options[ruleset_select.options.length] = new Option("'.JText::_('COM_TABULIZER_NONE').'", 0);
				}				
			}
		}				
		
	}	
';	

$document =& JFactory::getDocument();
$document->addScript($js_url);
$document->addStyleSheet($css_url);
$document->addScriptDeclaration($js_code, "text/javascript");

$document->setTitle($page_title);

$instructions_note = sprintf(JText::_('COM_TABULIZER_INSTRUCTIONS'),JText::_('COM_TABULIZER_TABLE_TEXT'),JText::_('COM_TABULIZER_CONVERT_TABLE'),JText::_('COM_TABULIZER_INSERT_TABLE'));
echo $instructions_note; 
?>
<div class="dialogcontainer">

<?php if ($allow_excel_loading) { ?>	
<span class="display_excel_span"><a href="javascript: TabulizerToggleExcelForm();" class="display_excel_link"><span id="display_excel_label"><?php echo JText::_('COM_TABULIZER_LOAD_EXCEL_SHOW_BTN'); ?></span></a></span>
<div id="excel_upload_div" style="display: none">

<form name="upload_form" id="upload_form" method="post" enctype="multipart/form-data" action="<?php echo JURI::base().'index.php?option=com_tabulizer&task=upload_excel_file&tmpl=component'; ?>" target="upload_target" >
<table>
<tr>
	<td><?php echo  JText::_('COM_TABULIZER_SHEET_ID'); ?>:</td><td><input type="text" name="f_sheet_id" id="f_sheet_id" value="1"></td><td><span class="field_tip"><?php echo JText::_('COM_TABULIZER_SHEET_ID_TIP'); ?></span></td>
</tr>	
<tr>
	<td><?php echo  JText::_('COM_TABULIZER_SHEET_SELECTION'); ?>:</td><td><input type="text" name="f_sheet_selection" id="f_sheet_selection" value=""></td><td><span class="field_tip"><?php echo JText::_('COM_TABULIZER_SHEET_SELECTION_TIP'); ?></span></td>
</tr>	
<tr>
	<td><?php echo  JText::_('COM_TABULIZER_SHEET_FILE'); ?>:</td><td><input type="file" name="sheet_file" id="sheet_file" value="*.xls"></td><td><span class="field_tip"><?php $max_sheet_file_size = number_format((MAX_UPLOAD_SHEET_FILE_SIZE/1024)); $max_sheet_file_size .= 'KB'; echo sprintf(JText::_('COM_TABULIZER_SHEET_FILE_TIP'), $max_sheet_file_size); ?></span></td>
</tr>	
<tr>
	<td><?php echo  JText::_('COM_TABULIZER_SHEET_PREFERENCES'); ?>:</td><td><input type="checkbox" value="1" id="f_read_hyperlinks" checked> <?php echo JText::_('COM_TABULIZER_SHEET_READ_HYPERLINKS');?> | <input type="checkbox" value="1" id="f_read_font"> <?php echo JText::_('COM_TABULIZER_SHEET_READ_FONT');?> | <input type="checkbox" value="1" id="f_read_color"> <?php echo JText::_('COM_TABULIZER_SHEET_READ_COLOR');?> | <input type="checkbox" value="1" id="f_remove_empty" checked> <?php echo JText::_('COM_TABULIZER_SHEET_REMOVE_EMPTY');?></td>
</tr>	
<tr>
	<td colspan="3"><input type="button" value="<?php echo  JText::_('COM_TABULIZER_LOAD_EXCEL_BTN'); ?>" onClick="TabulizerUploadExcel()" class="btn"></td>
</tr>
</table>	
<?php echo JHTML::_( 'form.token' ); ?>
</form>

<iframe id="upload_target" name="upload_target" src="" style="display: none;"></iframe>

<form name="excel_form" id="excel_form" method="post" onSubmit="return false">
<input type="hidden" name="sheet_filename" id="sheet_filename" value="">
<input type="hidden" name="sheet_id" id="sheet_id" value="">
<input type="hidden" name="sheet_selection" id="sheet_selection" value="">
<input type="hidden" name="sheet_read_hyperlinks" id="sheet_read_hyperlinks" value="">
<input type="hidden" name="sheet_read_font" id="sheet_read_font" value="">
<input type="hidden" name="sheet_read_color" id="sheet_read_color" value="">
<input type="hidden" name="sheet_remove_empty" id="sheet_remove_empty" value="">
<?php echo JHTML::_( 'form.token' ); ?>
</form>

</div>

<?php } else { ?>

<span class="display_excel_span"><a href="javascript: TabulizerToggleExcelForm();" class="display_excel_link"><span id="display_excel_label"><?php echo JText::_('COM_TABULIZER_LOAD_EXCEL_SHOW_BTN'); ?></span></a></span>
<div id="excel_upload_div" style="display: none">
<?php echo JText::_('COM_TABULIZER_LOAD_EXCEL_UNAVAILABLE'); ?>
</div>

<?php } /* $allow_excel_loading */ ?>

<span id="ajax_infobox"></span>

<form name="tabulizer_form" id="tabulizer_form" method="post" onSubmit="return false">
<table border="0" cellspacing="0" cellpadding="2" width="100%">

<tr>  	  
  <td nowrap><?php echo  JText::_('COM_TABULIZER_TABLE_TEXT'); ?>:<br/><textarea name="raw_text" id="tabulizer_text" cols="80" rows="10" class="input"></textarea></td>
</tr>  
<tr>  	
  <td nowrap><?php echo  JText::_('COM_TABULIZER_TABLE_HTML'); ?>:<br/><textarea name="html_text" id="tabulizer_html" cols="80" rows="10" class="input"></textarea></td>
</tr>

<tr>  	  
  <td nowrap>  
  <table width="100%">
  <tr>
  <td width="25%"><?php echo  JText::_('COM_TABULIZER_COLUMN_SEPARATOR'); ?>:</td>     
  <td width="75%"><select name="column_separator" id="column_separator">
  <option value="<?php echo SEPARATOR_COMMA;?>"><?php echo JText::_('COM_TABULIZER_COMMA_SEPARATOR'); ?></option>
  <option value="<?php echo SEPARATOR_SEMICOLON;?>"><?php echo JText::_('COM_TABULIZER_SEMICOLON_SEPARATOR'); ?></option>
  <option value="<?php echo SEPARATOR_ASTERISK;?>"><?php echo JText::_('COM_TABULIZER_ASTERISK_SEPARATOR'); ?></option>
  <option value="<?php echo SEPARATOR_CARET;?>"><?php echo JText::_('COM_TABULIZER_CARET_SEPARATOR'); ?></option>
  <option value="<?php echo SEPARATOR_SPACE;?>"><?php echo JText::_('COM_TABULIZER_SPACE_SEPARATOR'); ?></option>
  <option value="<?php echo SEPARATOR_TAB;?>"><?php echo JText::_('COM_TABULIZER_TAB_SEPARATOR'); ?></option>
  </select> <?php echo JText::_('COM_TABULIZER_COLUMN_ENCLOSURE'); ?> 
  <select name="column_enclosure" id="column_enclosure">
  <option value="<?php echo ENCLOSURE_NONE;?>"><?php echo JText::_('COM_TABULIZER_NO_ENCLOSURE'); ?></option>
  <option value="<?php echo ENCLOSURE_DOUBLE_QUOTES;?>" selected="selected"><?php echo JText::_('COM_TABULIZER_DOUBLE_QUOTES_ENCLOSURE'); ?></option>  
  <option value="<?php echo ENCLOSURE_SINGLE_QUOTES;?>"><?php echo JText::_('COM_TABULIZER_SINGLE_QUOTES_ENCLOSURE'); ?></option>    
  </select>    
  </td>
  </tr>	  
  <tr>	
  <td><?php echo  JText::_('COM_TABULIZER_COLUMN_CONSISTENCY'); ?>:</td>
  <td>
  <select name="column_consistency" id="column_consistency">
  <option value="1"><?php echo JText::_('COM_TABULIZER_COLUMN_CONSISTENCY_STRICT'); ?></option>
  <option value="0" selected="selected"><?php echo JText::_('COM_TABULIZER_COLUMN_CONSISTENCY_LOOSE'); ?></option>  
  </select>  
  </td> 	
  </tr>	  
  <tr>	
  <td><?php echo  JText::_('COM_TABULIZER_ARCHIVE_NAME'); ?>:</td><td><?php echo $archive_options; ?></td> 	
  </tr>	
  <tr>	
  <td><?php echo  JText::_('COM_TABULIZER_RULESET_NAME'); ?>:</td><td><?php echo $ruleset_options; ?></td>
  </tr>	 
  </table>      
  </td>
</tr> 
   
<tr>
<td align="left" valign="bottom" nowrap>
<hr/>
<input type="button" value="<?php echo  JText::_('COM_TABULIZER_CONVERT_TABLE'); ?>" onClick="TabulizerConvertClick()" class="btn">
<input type="submit" value="<?php echo  JText::_('COM_TABULIZER_INSERT_TABLE'); ?>" onClick="TabulizerInsertClick()" class="btn">
<input type="button" value="<?php echo  JText::_('COM_TABULIZER_CANCEL_CONVERSION'); ?>" onClick="TabulizerCancelClick()" class="btn">
</td>
</tr>

</table>
<input type="hidden" name="use_comments" value="<?php echo $use_comments; ?>" />
<?php echo JHTML::_( 'form.token' ); ?>

<?php if ($retabulizer) { ?>
<input type="hidden" name="caret_position" value="<?php echo $caret_position; ?>" />
<input type="hidden" name="editor_content" id="editor_content" value="" />
<input type="hidden" name="editor_replace_from" id="editor_replace_from" value="" />
<input type="hidden" name="editor_replace_to" id="editor_replace_to" value="" />
<?php } ?>

</form>

<div class="ruleset_description"><?php echo $init_description; ?></div>

</div>

